/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Specializes;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.Producer;
import javax.inject.Named;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotated;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bean.attributes.ImmutableBeanAttributes;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.SpecializationAndEnablementRegistry;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.slf4j.cal10n.LocLogger;

public abstract class AbstractBean<T, S>
extends RIBean<T> {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BEAN);
    protected Class<T> type;
    private boolean preInitialized;
    private boolean proxyRequired;
    private Producer<T> producer;

    public AbstractBean(BeanAttributes<T> attributes, String idSuffix, BeanManagerImpl beanManager) {
        super(attributes, idSuffix, beanManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preInitialize() {
        AbstractBean abstractBean = this;
        synchronized (abstractBean) {
            if (this.isSpecializing() && !this.preInitialized) {
                this.preInitialized = true;
                this.preSpecialize();
                this.specialize();
                this.checkSpecialization();
                this.postSpecialize();
            }
        }
    }

    @Override
    public void internalInitialize(BeanDeployerEnvironment environment) {
        this.preInitialize();
        log.trace((Enum)BeanMessage.CREATING_BEAN, new Object[]{this.getType()});
        this.proxyRequired = this.getScope() != null ? this.isNormalScoped() : false;
        log.trace((Enum)BeanMessage.QUALIFIERS_USED, new Object[]{this.getQualifiers(), this});
        log.trace((Enum)BeanMessage.USING_NAME, new Object[]{this.getName(), this});
        log.trace((Enum)BeanMessage.USING_SCOPE, new Object[]{this.getScope(), this});
    }

    @Override
    public void initializeAfterBeanDiscovery() {
        this.checkType();
    }

    protected abstract void checkType();

    public void checkSpecialization() {
        if (this.isSpecializing()) {
            boolean isNameDefined = this.getAnnotated().isAnnotationPresent(Named.class);
            String previousSpecializedBeanName = null;
            for (AbstractBean<?, ?> specializedBean : this.getSpecializedBeans()) {
                String name = specializedBean.getName();
                if (previousSpecializedBeanName != null && name != null && !previousSpecializedBeanName.equals(specializedBean.getName())) {
                    throw new DefinitionException(BeanMessage.BEANS_WITH_DIFFERENT_BEAN_NAMES_CANNOT_BE_SPECIALIZED, previousSpecializedBeanName, specializedBean.getName(), this);
                }
                previousSpecializedBeanName = name;
                if (isNameDefined && name != null) {
                    throw new DefinitionException(BeanMessage.NAME_NOT_ALLOWED_ON_SPECIALIZATION, this.getAnnotated());
                }
                for (Type type : specializedBean.getTypes()) {
                    if (this.getTypes().contains(type)) continue;
                    throw new DefinitionException(BeanMessage.SPECIALIZING_BEAN_MISSING_SPECIALIZED_TYPE, this, type, specializedBean);
                }
            }
        }
    }

    protected void postSpecialize() {
        HashSet<Annotation> qualifiers = new HashSet<Annotation>();
        qualifiers.addAll(this.attributes().getQualifiers());
        String name = this.attributes().getName();
        for (AbstractBean<?, ?> specializedBean : this.getSpecializedBeans()) {
            qualifiers.addAll(specializedBean.getQualifiers());
            if (specializedBean.getName() == null) continue;
            name = specializedBean.getName();
        }
        this.setAttributes(new ImmutableBeanAttributes(qualifiers, name, this.attributes()));
    }

    protected void preSpecialize() {
    }

    protected void specialize() {
    }

    public abstract Annotated getAnnotated();

    public abstract EnhancedAnnotated<T, S> getEnhancedAnnotated();

    protected Set<? extends AbstractBean<?, ?>> getSpecializedBeans() {
        return ((SpecializationAndEnablementRegistry)this.getBeanManager().getServices().get(SpecializationAndEnablementRegistry.class)).resolveSpecializedBeans(this);
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public boolean isDependent() {
        return Dependent.class.equals(this.getScope());
    }

    public boolean isSpecializing() {
        return this.getAnnotated().isAnnotationPresent(Specializes.class);
    }

    @Override
    public boolean isProxyRequired() {
        return this.proxyRequired;
    }

    public Producer<T> getProducer() {
        return this.producer;
    }

    public void setProducer(Producer<T> producer) {
        this.producer = producer;
    }
}

