/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.logging;

import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.WeldLogger;

@MessageLogger(projectCode="WELD-")
public interface ServletLogger
extends WeldLogger {
    public static final ServletLogger LOG = (ServletLogger)Logger.getMessageLogger(ServletLogger.class, (String)Category.SERVLET.getName());

    @Deprecated
    @Message(id=700, value="Not starting Weld/Servlet integration as Weld failed to initialize")
    public String notStarting();

    @Deprecated
    @Message(id=701, value="ServletContext is null")
    public String contextNull();

    @Deprecated
    @Message(id=702, value="Unable to find BeanManager for {0}", format=Message.Format.MESSAGE_FORMAT)
    public String beanManagerNotFound(Object var1);

    @Deprecated
    @Message(id=703, value="Cannot obtain request scoped beans from the request")
    public String requestScopeBeanStoreMissing();

    @Deprecated
    @Message(id=704, value="Unable to locate bean deployment archive for {0}", format=Message.Format.MESSAGE_FORMAT)
    public String beanDeploymentArchiveMissing(Object var1);

    @Deprecated
    @Message(id=705, value="Unable to locate bean manager for {0} in {1}", format=Message.Format.MESSAGE_FORMAT)
    public String beanManagerForArchiveNotFound(Object var1, Object var2);

    @Deprecated
    @Message(id=706, value="Cannot use WeldListener without ServletServices")
    public String illegalUseOfWeldListener();

    @Message(id=707, value="Non Http-Servlet lifecycle not defined")
    public IllegalStateException onlyHttpServletLifecycleDefined();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=708, value="Initializing request {0}", format=Message.Format.MESSAGE_FORMAT)
    public void requestInitialized(Object var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=709, value="Destroying request {0}", format=Message.Format.MESSAGE_FORMAT)
    public void requestDestroyed(Object var1);

    @Message(id=710, value="Cannot inject {0} outside of a Servlet request", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException cannotInjectObjectOutsideOfServletRequest(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=711, value="Context activation pattern {0} ignored as it is overriden by the integrator.", format=Message.Format.MESSAGE_FORMAT)
    public void webXmlMappingPatternIgnored(String var1);
}

