/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.bytecode;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class DescriptorUtils {
    public static final String VOID_CLASS_DESCRIPTOR = "V";
    public static final String BYTE_CLASS_DESCRIPTOR = "B";
    public static final String CHAR_CLASS_DESCRIPTOR = "C";
    public static final String DOUBLE_CLASS_DESCRIPTOR = "D";
    public static final String FLOAT_CLASS_DESCRIPTOR = "F";
    public static final String INT_CLASS_DESCRIPTOR = "I";
    public static final String LONG_CLASS_DESCRIPTOR = "J";
    public static final String SHORT_CLASS_DESCRIPTOR = "S";
    public static final String BOOLEAN_CLASS_DESCRIPTOR = "Z";

    private DescriptorUtils() {
    }

    private static String extToInt(String className) {
        String repl = className.replace(".", "/");
        return 'L' + repl + ';';
    }

    public static String[] descriptorStringToParameterArray(String methodDescriptor) {
        int i = 1;
        ArrayList<String> ret = new ArrayList<String>();
        int arraystart = -1;
        while (methodDescriptor.charAt(i) != ')') {
            String type = null;
            if (methodDescriptor.charAt(i) == '[') {
                if (arraystart == -1) {
                    arraystart = i;
                }
            } else {
                if (methodDescriptor.charAt(i) == 'L') {
                    int start = i++;
                    while (methodDescriptor.charAt(i) != ';') {
                        ++i;
                    }
                    type = arraystart == -1 ? methodDescriptor.substring(start, i) : methodDescriptor.substring(arraystart, i);
                } else {
                    type = arraystart == -1 ? methodDescriptor.charAt(i) + "" : methodDescriptor.substring(arraystart, i + 1);
                }
                arraystart = -1;
                ret.add(type);
            }
            ++i;
        }
        String[] r = new String[ret.size()];
        for (int j = 0; j < ret.size(); ++j) {
            r[j] = (String)ret.get(j);
        }
        return r;
    }

    public static String classToStringRepresentation(Class<?> c) {
        if (Void.TYPE.equals(c)) {
            return VOID_CLASS_DESCRIPTOR;
        }
        if (Byte.TYPE.equals(c)) {
            return BYTE_CLASS_DESCRIPTOR;
        }
        if (Character.TYPE.equals(c)) {
            return CHAR_CLASS_DESCRIPTOR;
        }
        if (Double.TYPE.equals(c)) {
            return DOUBLE_CLASS_DESCRIPTOR;
        }
        if (Float.TYPE.equals(c)) {
            return FLOAT_CLASS_DESCRIPTOR;
        }
        if (Integer.TYPE.equals(c)) {
            return INT_CLASS_DESCRIPTOR;
        }
        if (Long.TYPE.equals(c)) {
            return LONG_CLASS_DESCRIPTOR;
        }
        if (Short.TYPE.equals(c)) {
            return SHORT_CLASS_DESCRIPTOR;
        }
        if (Boolean.TYPE.equals(c)) {
            return BOOLEAN_CLASS_DESCRIPTOR;
        }
        if (c.isArray()) {
            return c.getName().replace(".", "/");
        }
        return DescriptorUtils.extToInt(c.getName());
    }

    public static boolean isPrimitive(String descriptor) {
        return descriptor.length() == 1;
    }

    public static boolean isWide(String descriptor) {
        if (!DescriptorUtils.isPrimitive(descriptor)) {
            return false;
        }
        char c = descriptor.charAt(0);
        return c == 'D' || c == 'J';
    }

    public static boolean isWide(Class<?> cls) {
        return cls == Double.TYPE || cls == Long.TYPE;
    }

    public static String getConstructorDescriptor(Constructor<?> c) {
        StringBuilder desc = new StringBuilder("(");
        for (Class<?> p : c.getParameterTypes()) {
            desc.append(DescriptorUtils.classToStringRepresentation(p));
        }
        desc.append(")");
        desc.append(VOID_CLASS_DESCRIPTOR);
        return desc.toString();
    }

    public static String[] getParameterTypes(Method m) {
        String[] ret = new String[m.getParameterTypes().length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = DescriptorUtils.classToStringRepresentation(m.getParameterTypes()[i]);
        }
        return ret;
    }

    public static String[] getParameterTypes(Class<?>[] parameters) {
        String[] ret = new String[parameters.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = DescriptorUtils.classToStringRepresentation(parameters[i]);
        }
        return ret;
    }

    public static String getMethodDescriptor(Method m) {
        StringBuilder desc = new StringBuilder("(");
        for (Class<?> p : m.getParameterTypes()) {
            desc.append(DescriptorUtils.classToStringRepresentation(p));
        }
        desc.append(")");
        desc.append(DescriptorUtils.classToStringRepresentation(m.getReturnType()));
        return desc.toString();
    }

    public static String getMethodDescriptor(String[] parameters, String returnType) {
        StringBuilder desc = new StringBuilder("(");
        for (String p : parameters) {
            desc.append(p);
        }
        desc.append(")");
        desc.append(returnType);
        return desc.toString();
    }
}

