/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.annotated.slim.backed;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedCallable;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedMember;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedParameter;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedType;
import org.jboss.weld.exceptions.InvalidObjectException;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.resources.SharedObjectCache;
import org.jboss.weld.serialization.MethodHolder;
import org.jboss.weld.util.collections.WeldCollections;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;

@SuppressWarnings(value={"SE_BAD_FIELD", "SE_NO_SUITABLE_CONSTRUCTOR", "SE_NO_SERIALVERSIONID"}, justification="False positive from FindBugs - serialization is handled by SerializationProxy.")
public class BackedAnnotatedMethod<X>
extends BackedAnnotatedCallable<X, Method>
implements AnnotatedMethod<X>,
Serializable {
    private final Method method;

    public static <X, Y extends X> AnnotatedMethod<X> of(Method method, BackedAnnotatedType<Y> declaringType, SharedObjectCache sharedObjectCache) {
        BackedAnnotatedType downcastDeclaringType = (BackedAnnotatedType)Reflections.cast(declaringType);
        return new BackedAnnotatedMethod<X>(method, downcastDeclaringType, sharedObjectCache);
    }

    public BackedAnnotatedMethod(Method method, BackedAnnotatedType<X> declaringType, SharedObjectCache sharedObjectCache) {
        super(method, method.getGenericReturnType(), declaringType, sharedObjectCache);
        this.method = method;
    }

    @Override
    protected List<AnnotatedParameter<X>> initParameters(Method method, SharedObjectCache sharedObjectCache) {
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        ArrayList parameters = new ArrayList(genericParameterTypes.length);
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < genericParameterTypes.length; ++i) {
            Type parameterType = genericParameterTypes[i];
            parameters.add(BackedAnnotatedParameter.of(parameterType, parameterAnnotations[i], i, this, sharedObjectCache));
        }
        return WeldCollections.immutableList(parameters);
    }

    public Method getJavaMember() {
        return this.method;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        return this.method.getAnnotation(annotationType);
    }

    @Override
    protected AnnotatedElement getAnnotatedElement() {
        return this.method;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.method.isAnnotationPresent(annotationType);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BackedAnnotatedMethod other = (BackedAnnotatedMethod)obj;
        return !(this.method == null ? other.method != null : !this.method.equals(other.method));
    }

    public String toString() {
        return Formats.formatAnnotatedMethod(this);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw BeanLogger.LOG.proxyRequired();
    }

    private static class SerializationProxy<X>
    extends BackedAnnotatedMember.BackedAnnotatedMemberSerializationProxy<X, AnnotatedMethod<X>> {
        private static final long serialVersionUID = 8008578690970722095L;

        public SerializationProxy(BackedAnnotatedMethod<X> method) {
            super(method.getDeclaringType(), MethodHolder.of(method));
        }

        private Object readResolve() throws ObjectStreamException {
            return this.resolve();
        }

        @Override
        protected Iterable<AnnotatedMethod<X>> getCandidates() {
            return (Iterable)Reflections.cast(this.type.getMethods());
        }
    }
}

