/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Serializable;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.PassivationCapable;
import org.jboss.weld.Container;
import org.jboss.weld.bean.ForwardingBean;
import org.jboss.weld.bean.WrappedContextual;
import org.jboss.weld.context.ForwardingContextual;
import org.jboss.weld.serialization.BeanIdentifierIndex;
import org.jboss.weld.serialization.spi.BeanIdentifier;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.serialization.spi.helpers.SerializableContextual;
import org.jboss.weld.util.reflection.Reflections;

public class SerializableContextualFactory {
    private SerializableContextualFactory() {
    }

    public static <C extends Contextual<I>, I> SerializableContextual<C, I> create(String contextId, C contextual, ContextualStore contextualStore, BeanIdentifierIndex beanIdentifierIndex) {
        if (contextual instanceof Bean) {
            if (contextual instanceof PassivationCapable) {
                return new PassivationCapableSerializableBean(contextId, (Bean)Reflections.cast(contextual), contextualStore, beanIdentifierIndex);
            }
            return new DefaultSerializableBean(contextId, (Bean)Reflections.cast(contextual), contextualStore, beanIdentifierIndex);
        }
        if (contextual instanceof PassivationCapable) {
            return new PassivationCapableSerializableContextual(contextId, contextual, contextualStore, beanIdentifierIndex);
        }
        return new DefaultSerializableContextual(contextId, contextual, contextualStore, beanIdentifierIndex);
    }

    private static class PassivationCapableSerializableBean<B extends Bean<I> & PassivationCapable, I>
    extends AbstractSerializableBean<B, I>
    implements PassivationCapable {
        private static final long serialVersionUID = 7458443513156329183L;

        public PassivationCapableSerializableBean(String contextId, B bean, ContextualStore contextualStore, BeanIdentifierIndex beanIdentifierIndex) {
            super(contextId, bean, contextualStore, beanIdentifierIndex);
        }

        public String getId() {
            return ((PassivationCapable)this.get()).getId();
        }
    }

    private static class DefaultSerializableBean<B extends Bean<I>, I>
    extends AbstractSerializableBean<B, I> {
        private static final long serialVersionUID = -8901252027789701049L;

        public DefaultSerializableBean(String contextId, B bean, ContextualStore contextualStore, BeanIdentifierIndex beanIdentifierIndex) {
            super(contextId, bean, contextualStore, beanIdentifierIndex);
        }
    }

    private static class PassivationCapableSerializableContextual<C extends Contextual<I> & PassivationCapable, I>
    extends AbstractSerializableContextual<C, I>
    implements PassivationCapable {
        private static final long serialVersionUID = -2753893863961869301L;

        public PassivationCapableSerializableContextual(String contextId, C contextual, ContextualStore contextualStore, BeanIdentifierIndex beanIdentifierIndex) {
            super(contextId, contextual, contextualStore, beanIdentifierIndex);
        }

        public String getId() {
            return ((PassivationCapable)this.get()).getId();
        }
    }

    private static class DefaultSerializableContextual<C extends Contextual<I>, I>
    extends AbstractSerializableContextual<C, I> {
        private static final long serialVersionUID = -5102624795925717767L;

        public DefaultSerializableContextual(String contextId, C contextual, ContextualStore contextualStore, BeanIdentifierIndex beanIdentifierIndex) {
            super(contextId, contextual, contextualStore, beanIdentifierIndex);
        }
    }

    private static abstract class AbstractSerializableContextual<C extends Contextual<I>, I>
    extends ForwardingContextual<I>
    implements SerializableContextual<C, I>,
    WrappedContextual<I> {
        private static final long serialVersionUID = 107855630671709443L;
        private final SerializableContextualHolder<C, I> holder;

        AbstractSerializableContextual(String contextId, C contextual, ContextualStore contextualStore, BeanIdentifierIndex beanIdentifierIndex) {
            this.holder = new SerializableContextualHolder(contextId, contextual, contextualStore, beanIdentifierIndex);
        }

        @Override
        public Contextual<I> delegate() {
            return this.get();
        }

        public C get() {
            return this.holder.get();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof AbstractSerializableContextual) {
                return this.delegate().equals(((AbstractSerializableContextual)obj).get());
            }
            return this.delegate().equals(obj);
        }

        @Override
        public int hashCode() {
            return this.delegate().hashCode();
        }
    }

    private static abstract class AbstractSerializableBean<B extends Bean<I>, I>
    extends ForwardingBean<I>
    implements SerializableContextual<B, I>,
    WrappedContextual<I> {
        private static final long serialVersionUID = 7594992948498685840L;
        private final SerializableContextualHolder<B, I> holder;

        AbstractSerializableBean(String contextId, B bean, ContextualStore contextualStore, BeanIdentifierIndex beanIdentifierIndex) {
            this.holder = new SerializableContextualHolder(contextId, bean, contextualStore, beanIdentifierIndex);
        }

        public B get() {
            return (B)((Bean)this.holder.get());
        }

        @Override
        public Bean<I> delegate() {
            return this.get();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof AbstractSerializableBean) {
                return this.delegate().equals(((AbstractSerializableBean)obj).get());
            }
            return this.delegate().equals(obj);
        }

        @Override
        public int hashCode() {
            return this.delegate().hashCode();
        }
    }

    private static final class SerializableContextualHolder<C extends Contextual<I>, I>
    implements Serializable {
        private static final long serialVersionUID = 46941665668478370L;
        @SuppressWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="A cache which is lazily loaded")
        private transient C cached;
        private final C serializable;
        private final BeanIdentifier identifier;
        private final Integer identifierIndex;
        private final String contextId;
        private transient ContextualStore cachedContextualStore;
        private transient BeanIdentifierIndex beanIdentifierIndex;

        SerializableContextualHolder(String contextId, C contextual, ContextualStore contextualStore, BeanIdentifierIndex beanIdentifierIndex) {
            this.contextId = contextId;
            this.cachedContextualStore = contextualStore;
            if (contextual instanceof Serializable) {
                this.serializable = contextual;
                this.identifier = null;
                this.identifierIndex = null;
            } else {
                Integer idx;
                this.serializable = null;
                BeanIdentifier beanIdentifier = this.getId(contextual, contextualStore);
                Integer n = idx = beanIdentifierIndex.isBuilt() ? beanIdentifierIndex.getIndex(beanIdentifier) : null;
                if (idx != null) {
                    this.identifierIndex = idx;
                    this.identifier = null;
                } else {
                    this.identifierIndex = null;
                    this.identifier = beanIdentifier;
                }
            }
            this.cached = contextual;
        }

        protected BeanIdentifier getId(C contextual, ContextualStore contextualStore) {
            return contextualStore.putIfAbsent(contextual);
        }

        protected ContextualStore getContextualStore() {
            if (this.cachedContextualStore == null) {
                this.cachedContextualStore = (ContextualStore)Container.instance(this.contextId).services().get(ContextualStore.class);
            }
            return this.cachedContextualStore;
        }

        protected BeanIdentifierIndex getBeanIdentifierIndex() {
            if (this.beanIdentifierIndex == null) {
                this.beanIdentifierIndex = (BeanIdentifierIndex)Container.instance(this.contextId).services().get(BeanIdentifierIndex.class);
            }
            return this.beanIdentifierIndex;
        }

        protected C get() {
            if (this.cached == null) {
                this.loadContextual();
            }
            return this.cached;
        }

        private void loadContextual() {
            if (this.serializable != null) {
                this.cached = this.serializable;
            } else if (this.identifierIndex != null) {
                this.cached = this.getContextualStore().getContextual(this.getBeanIdentifierIndex().getIdentifier(this.identifierIndex));
            } else if (this.identifier != null) {
                this.cached = this.getContextualStore().getContextual(this.identifier);
            }
            if (this.cached == null) {
                throw new IllegalStateException("Error restoring serialized contextual with id " + this.identifier);
            }
        }
    }
}

