/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.inject.spi.ObserverMethod;
import org.jboss.weld.bootstrap.events.ProcessAnnotatedTypeEventResolvable;
import org.jboss.weld.event.ExtensionObserverMethodImpl;
import org.jboss.weld.event.ResolvedObservers;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.resolution.AssignabilityRules;
import org.jboss.weld.resolution.EventTypeAssignabilityRules;
import org.jboss.weld.resolution.QualifierInstance;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.resolution.TypeSafeResolver;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.Observers;
import org.jboss.weld.util.reflection.Reflections;

public class TypeSafeObserverResolver
extends TypeSafeResolver<Resolvable, ObserverMethod<?>, Set<ObserverMethod<?>>, ResolvedObservers<?>> {
    private final MetaAnnotationStore metaAnnotationStore;
    private final AssignabilityRules rules;

    public TypeSafeObserverResolver(MetaAnnotationStore metaAnnotationStore, Iterable<ObserverMethod<?>> observers) {
        super(observers);
        this.metaAnnotationStore = metaAnnotationStore;
        this.rules = EventTypeAssignabilityRules.instance();
    }

    @Override
    protected boolean matches(Resolvable resolvable, ObserverMethod<?> observer) {
        if (!this.rules.matches(observer.getObservedType(), resolvable.getTypes())) {
            return false;
        }
        if (!Beans.containsAllQualifiers(QualifierInstance.of(observer.getObservedQualifiers(), this.metaAnnotationStore), resolvable.getQualifiers())) {
            return false;
        }
        if (observer instanceof ExtensionObserverMethodImpl) {
            ExtensionObserverMethodImpl extensionObserver = (ExtensionObserverMethodImpl)observer;
            if (resolvable instanceof ProcessAnnotatedTypeEventResolvable && !extensionObserver.getRequiredAnnotations().isEmpty()) {
                ProcessAnnotatedTypeEventResolvable patResolvable = (ProcessAnnotatedTypeEventResolvable)resolvable;
                return patResolvable.containsRequiredAnnotations(extensionObserver.getRequiredAnnotations());
            }
        } else {
            return !this.isContainerLifecycleEvent(resolvable);
        }
        return true;
    }

    protected boolean isContainerLifecycleEvent(Resolvable resolvable) {
        for (Type type : resolvable.getTypes()) {
            if (!Observers.CONTAINER_LIFECYCLE_EVENT_TYPES.contains(Reflections.getRawType(type))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Set<ObserverMethod<?>> filterResult(Set<ObserverMethod<?>> matched) {
        return matched;
    }

    @Override
    protected Set<ObserverMethod<?>> sortResult(Set<ObserverMethod<?>> matched) {
        return matched;
    }

    @Override
    protected ResolvedObservers<?> makeResultImmutable(Set<ObserverMethod<?>> result) {
        return ResolvedObservers.of((Set)Reflections.cast(result));
    }

    public MetaAnnotationStore getMetaAnnotationStore() {
        return this.metaAnnotationStore;
    }
}

