package org.jboss.weld.logging;

import javax.enterprise.context.spi.Context;
import org.jboss.weld.exceptions.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.weld.logging.WeldLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import org.jboss.weld.exceptions.DeploymentException;
import java.lang.Class;
import org.jboss.weld.exceptions.DefinitionException;
import java.util.Arrays;
import org.jboss.weld.exceptions.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2018-04-24T12:17:16+0200")
public class ContextLogger_$logger extends DelegatingBasicLogger implements ContextLogger,org.jboss.weld.logging.WeldLogger,BasicLogger,Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ContextLogger_$logger.class.getName();
    public ContextLogger_$logger(final Logger log) {
        super(log);
    }
    @Override
    public final void contextualInstanceFound(final Object param1, final Object param2, final Object param3) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, contextualInstanceFound$str(), param1, param2, param3);
    }
    private static final String contextualInstanceFound = "WELD-000200: Looked for {0} and got {1} in {2}";
    protected String contextualInstanceFound$str() {
        return contextualInstanceFound;
    }
    @Override
    public final void contextCleared(final Object param1) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, contextCleared$str(), param1);
    }
    private static final String contextCleared = "WELD-000201: Context {0} cleared";
    protected String contextCleared$str() {
        return contextCleared;
    }
    @Override
    public final void contextualInstanceAdded(final Object param1, final Object param2, final Object param3) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, contextualInstanceAdded$str(), param1, param2, param3);
    }
    private static final String contextualInstanceAdded = "WELD-000202: Added {0} with key {1} to {2}";
    protected String contextualInstanceAdded$str() {
        return contextualInstanceAdded;
    }
    @Override
    public final void contextualInstanceRemoved(final Object param1, final Object param2) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, contextualInstanceRemoved$str(), param1, param2);
    }
    private static final String contextualInstanceRemoved = "WELD-000203: Removed {0} from {1}";
    protected String contextualInstanceRemoved$str() {
        return contextualInstanceRemoved;
    }
    private static final String delimiterInPrefix = "WELD-000211: The delimiter \"{0}\" should not be in the prefix \"{1}\"";
    protected String delimiterInPrefix$str() {
        return delimiterInPrefix;
    }
    @Override
    public final IllegalArgumentException delimiterInPrefix(final Object param1, final Object param2) {
        final IllegalArgumentException result = new IllegalArgumentException(java.text.MessageFormat.format(delimiterInPrefix$str(), param1, param2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String contextualIsNull = "WELD-000212: No contextual specified to retrieve (null)";
    protected String contextualIsNull$str() {
        return contextualIsNull;
    }
    @Override
    public final IllegalArgumentException contextualIsNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(contextualIsNull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noBeanStoreAvailable = "WELD-000213: No bean store available for {0}";
    protected String noBeanStoreAvailable$str() {
        return noBeanStoreAvailable;
    }
    @Override
    public final IllegalStateException noBeanStoreAvailable(final Object param1) {
        final IllegalStateException result = new IllegalStateException(java.text.MessageFormat.format(noBeanStoreAvailable$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void beanStoreDetached(final Object param1) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, beanStoreDetached$str(), param1);
    }
    private static final String beanStoreDetached = "WELD-000215: Bean store {0} is detached";
    protected String beanStoreDetached$str() {
        return beanStoreDetached;
    }
    @Override
    public final void updatingStoreWithContextualUnderId(final Object param1, final Object param2) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, updatingStoreWithContextualUnderId$str(), param1, param2);
    }
    private static final String updatingStoreWithContextualUnderId = "WELD-000216: Updating underlying store with contextual {0} under ID {1}";
    protected String updatingStoreWithContextualUnderId$str() {
        return updatingStoreWithContextualUnderId;
    }
    @Override
    public final void addingDetachedContextualUnderId(final Object param1, final Object param2) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, addingDetachedContextualUnderId$str(), param1, param2);
    }
    private static final String addingDetachedContextualUnderId = "WELD-000217: Adding detached contextual {0} under ID {1}";
    protected String addingDetachedContextualUnderId$str() {
        return addingDetachedContextualUnderId;
    }
    @Override
    public final void removedKeyFromSession(final Object param1, final Object param2) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, removedKeyFromSession$str(), param1, param2);
    }
    private static final String removedKeyFromSession = "WELD-000218: Removed {0} from session {1}";
    protected String removedKeyFromSession$str() {
        return removedKeyFromSession;
    }
    @Override
    public final void unableToRemoveKeyFromSession(final Object param1) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, unableToRemoveKeyFromSession$str(), param1);
    }
    private static final String unableToRemoveKeyFromSession = "WELD-000219: Unable to remove {0} from non-existent session";
    protected String unableToRemoveKeyFromSession$str() {
        return unableToRemoveKeyFromSession;
    }
    @Override
    public final void addedKeyToSession(final Object param1, final Object param2) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, addedKeyToSession$str(), param1, param2);
    }
    private static final String addedKeyToSession = "WELD-000220: Added {0} to session {1}";
    protected String addedKeyToSession$str() {
        return addedKeyToSession;
    }
    @Override
    public final void unableToAddKeyToSession(final Object param1) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, unableToAddKeyToSession$str(), param1);
    }
    private static final String unableToAddKeyToSession = "WELD-000221: Unable to add {0} to session as no session could be obtained";
    protected String unableToAddKeyToSession$str() {
        return unableToAddKeyToSession;
    }
    @Override
    public final void loadingBeanStoreMapFromSession(final Object param1, final Object param2) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, loadingBeanStoreMapFromSession$str(), param1, param2);
    }
    private static final String loadingBeanStoreMapFromSession = "WELD-000222: Loading bean store {0} map from session {1}";
    protected String loadingBeanStoreMapFromSession$str() {
        return loadingBeanStoreMapFromSession;
    }
    private static final String contextHasNullScope = "WELD-000223: Context.getScope() returned null for {0}";
    protected String contextHasNullScope$str() {
        return contextHasNullScope;
    }
    @Override
    public final DefinitionException contextHasNullScope(final Object param1) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(contextHasNullScope$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void unableToClearBeanStore(final Object beanStore) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.WARN, null, unableToClearBeanStore$str(), beanStore);
    }
    private static final String unableToClearBeanStore = "WELD-000224: Unable to clear the bean store {0}.";
    protected String unableToClearBeanStore$str() {
        return unableToClearBeanStore;
    }
    @Override
    public final void beanStoreLeakDuringAssociation(final Object context, final Object info) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.WARN, null, beanStoreLeakDuringAssociation$str(), context, info);
    }
    private static final String beanStoreLeakDuringAssociation = "WELD-000225: Bean store leak detected during {0} association: {1}";
    protected String beanStoreLeakDuringAssociation$str() {
        return beanStoreLeakDuringAssociation;
    }
    private static final String cannotRegisterContext = "WELD-000226: Cannot register additional context for scope: {0}, {1}";
    protected String cannotRegisterContext$str() {
        return cannotRegisterContext;
    }
    @Override
    public final DeploymentException cannotRegisterContext(final Class<? extends java.lang.annotation.Annotation> scope, final Context context) {
        final DeploymentException result = new DeploymentException(java.text.MessageFormat.format(cannotRegisterContext$str(), scope, context));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String beanIdentifierIndexInconsistencyDetected = "WELD-000227: Bean identifier index inconsistency detected - the distributed container probably does not work with identical applications\nExpected hash: {0}\nCurrent index: {1}";
    protected String beanIdentifierIndexInconsistencyDetected$str() {
        return beanIdentifierIndexInconsistencyDetected;
    }
    @Override
    public final IllegalStateException beanIdentifierIndexInconsistencyDetected(final Object hash, final Object index) {
        final IllegalStateException result = new IllegalStateException(java.text.MessageFormat.format(beanIdentifierIndexInconsistencyDetected$str(), hash, index));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void beanStoreLeakAffectedBeanIdentifiers(final Object context, final Object identifiers) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, beanStoreLeakAffectedBeanIdentifiers$str(), context, identifiers);
    }
    private static final String beanStoreLeakAffectedBeanIdentifiers = "WELD-000228: Bean store leak detected during {0} association - instances of beans with the following identifiers might not be destroyed correctly: {1}";
    protected String beanStoreLeakAffectedBeanIdentifiers$str() {
        return beanStoreLeakAffectedBeanIdentifiers;
    }
    private static final String contextualReferenceNotValidAfterShutdown = "WELD-000229: Contextual reference of {0} is not valid after container {1} shutdown";
    protected String contextualReferenceNotValidAfterShutdown$str() {
        return contextualReferenceNotValidAfterShutdown;
    }
    @Override
    public final IllegalStateException contextualReferenceNotValidAfterShutdown(final Object bean, final Object contextId) {
        final IllegalStateException result = new IllegalStateException(java.text.MessageFormat.format(contextualReferenceNotValidAfterShutdown$str(), bean, contextId));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void catchingDebug(final Throwable throwable) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.DEBUG, throwable, catchingDebug$str());
    }
    private static final String catchingDebug = "Catching";
    protected String catchingDebug$str() {
        return catchingDebug;
    }
}
