package org.jboss.weld.logging;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.reflect.Method;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.NoSuchMethodException;
import java.lang.reflect.Type;
import org.jboss.weld.logging.WeldLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import java.lang.Class;
import org.jboss.weld.exceptions.DefinitionException;
import java.util.Arrays;
import org.jboss.weld.exceptions.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2021-01-12T17:18:42+0100")
public class ReflectionLogger_$logger extends DelegatingBasicLogger implements ReflectionLogger, org.jboss.weld.logging.WeldLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ReflectionLogger_$logger.class.getName();
    public ReflectionLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void missingRetention(final Object param1) {
        super.log.logv(FQCN, DEBUG, null, missingRetention$str(), param1);
    }
    protected String missingRetention$str() {
        return "WELD-000600: {0} is missing @Retention(RUNTIME). Weld will use this annotation, however this may make the application unportable.";
    }
    @Override
    public final void missingTarget(final Object param1) {
        super.log.logv(FQCN, DEBUG, null, missingTarget$str(), param1);
    }
    protected String missingTarget$str() {
        return "WELD-000601: {0} is missing @Target. Weld will use this annotation, however this may make the application unportable.";
    }
    @Override
    public final void missingTargetTypeMethodOrTargetType(final Object param1) {
        super.log.logv(FQCN, DEBUG, null, missingTargetTypeMethodOrTargetType$str(), param1);
    }
    protected String missingTargetTypeMethodOrTargetType$str() {
        return "WELD-000602: {0} is not declared @Target(TYPE, METHOD) or @Target(TYPE). Weld will use this annotation, however this may make the application unportable.";
    }
    @Override
    public final void missingTargetMethodFieldType(final Object param1) {
        super.log.logv(FQCN, DEBUG, null, missingTargetMethodFieldType$str(), param1);
    }
    protected String missingTargetMethodFieldType$str() {
        return "WELD-000604: {0} is not declared @Target(METHOD, FIELD, TYPE). Weld will use this annotation, however this may make the application unportable.";
    }
    @Override
    public final void missingTargetMethodFieldTypeParameterOrTargetMethodTypeOrTargetMethodOrTargetTypeOrTargetField(final Object param1) {
        super.log.logv(FQCN, DEBUG, null, missingTargetMethodFieldTypeParameterOrTargetMethodTypeOrTargetMethodOrTargetTypeOrTargetField$str(), param1);
    }
    protected String missingTargetMethodFieldTypeParameterOrTargetMethodTypeOrTargetMethodOrTargetTypeOrTargetField$str() {
        return "WELD-000605: {0} is not declared @Target(METHOD, FIELD, TYPE, PARAMETER), @Target(METHOD, TYPE), @Target(METHOD), @Target(TYPE) or @Target(FIELD). Weld will use this annotation, however this may make the application unportable.";
    }
    protected String unableToGetParameterName$str() {
        return "WELD-000606: Unable to determine name of parameter";
    }
    @Override
    public final IllegalArgumentException unableToGetParameterName() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unableToGetParameterName$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String annotationMapNull$str() {
        return "WELD-000607: annotationMap cannot be null";
    }
    @Override
    public final WeldException annotationMapNull() {
        final WeldException result = new WeldException(String.format(getLoggingLocale(), annotationMapNull$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String declaredAnnotationMapNull$str() {
        return "WELD-000608: declaredAnnotationMap cannot be null";
    }
    @Override
    public final WeldException declaredAnnotationMapNull() {
        final WeldException result = new WeldException(String.format(getLoggingLocale(), declaredAnnotationMapNull$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToGetConstructorOnDeserialization$str() {
        return "WELD-000610: Unable to deserialize constructor. Declaring class {0}, index {1}";
    }
    @Override
    public final WeldException unableToGetConstructorOnDeserialization(final Object param1, final Object param2, final Throwable cause) {
        final WeldException result = new WeldException(_formatMessage(unableToGetConstructorOnDeserialization$str(), param1, param2), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private String _formatMessage(final String format, final Object... args) {
        final java.text.MessageFormat formatter = new java.text.MessageFormat(format, getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new java.text.FieldPosition(0)).toString();
    }
    protected String unableToGetMethodOnDeserialization$str() {
        return "WELD-000611: Unable to deserialize method. Declaring class {0}, index {1}";
    }
    @Override
    public final WeldException unableToGetMethodOnDeserialization(final Object param1, final Object param2, final Throwable cause) {
        final WeldException result = new WeldException(_formatMessage(unableToGetMethodOnDeserialization$str(), param1, param2), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToGetFieldOnDeserialization$str() {
        return "WELD-000612: Unable to deserialize field. Declaring class {0}, field name {1}";
    }
    @Override
    public final WeldException unableToGetFieldOnDeserialization(final Object param1, final Object param2, final Throwable cause) {
        final WeldException result = new WeldException(_formatMessage(unableToGetFieldOnDeserialization$str(), param1, param2), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String incorrectNumberOfAnnotatedParametersMethod$str() {
        return "WELD-000614: Incorrect number of AnnotatedParameters {0} on AnnotatedMethod {1}. AnnotatedMethod has {2} as parameters but should have {3} as parameters";
    }
    @Override
    public final DefinitionException incorrectNumberOfAnnotatedParametersMethod(final Object param1, final Object param2, final Object param3, final Object param4) {
        final DefinitionException result = new DefinitionException(_formatMessage(incorrectNumberOfAnnotatedParametersMethod$str(), param1, param2, param3, param4));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String reflectionfactoryInstantiationFailed$str() {
        return "WELD-000616: Instantiation through ReflectionFactory of {0} failed";
    }
    @Override
    public final WeldException reflectionfactoryInstantiationFailed(final Object param1, final Throwable cause) {
        final WeldException result = new WeldException(_formatMessage(reflectionfactoryInstantiationFailed$str(), param1), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsafeInstantiationFailed$str() {
        return "WELD-000617: Instantiation through Unsafe of {0} failed";
    }
    @Override
    public final WeldException unsafeInstantiationFailed(final Object param1, final Throwable cause) {
        final WeldException result = new WeldException(_formatMessage(unsafeInstantiationFailed$str(), param1), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void lifecycleCallbackInterceptorWithInvalidBindingTarget(final Object interceptor, final Object binding, final Object elementTypes) {
        super.log.logv(FQCN, WARN, null, lifecycleCallbackInterceptorWithInvalidBindingTarget$str(), interceptor, binding, elementTypes);
    }
    protected String lifecycleCallbackInterceptorWithInvalidBindingTarget$str() {
        return "WELD-000619: A lifecycle callback interceptor declares an interceptor binding with target other than ElementType.TYPE\n  {0}\n  Binding: {1}\n  Target: {2}";
    }
    @Override
    public final void missingTargetMethodFieldParameterType(final Object param1) {
        super.log.logv(FQCN, DEBUG, null, missingTargetMethodFieldParameterType$str(), param1);
    }
    protected String missingTargetMethodFieldParameterType$str() {
        return "WELD-000620: {0} is not declared @Target(METHOD, FIELD, PARAMETER, TYPE). Weld will use this annotation, however this may make the application unportable.";
    }
    @Override
    public final void invalidInterceptorBindingTargetDeclaration(final Object param1, final Object param2, final Object param3, final Object param4) {
        super.log.logv(FQCN, WARN, null, invalidInterceptorBindingTargetDeclaration$str(), param1, param2, param3, param4);
    }
    protected String invalidInterceptorBindingTargetDeclaration$str() {
        return "WELD-000621: Interceptor binding {0} with @Target defined as {1} should not be applied on interceptor binding {2} with @Target definition: {3}";
    }
    protected String illegalArgumentExceptionOnReflectionInvocation$str() {
        return "WELD-000622: IllegalArgumentException invoking {2} on {1} ({0}) with parameters {3}";
    }
    @Override
    public final WeldException illegalArgumentExceptionOnReflectionInvocation(final Class<?> clazz, final Object instance, final Method method, final String parameters, final Throwable cause) {
        final WeldException result = new WeldException(_formatMessage(illegalArgumentExceptionOnReflectionInvocation$str(), clazz, instance, method, parameters), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownType$str() {
        return "WELD-000623: Unknown type {0}.";
    }
    @Override
    public final IllegalArgumentException unknownType(final Type type) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(unknownType$str(), type));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidTypeArgumentCombination$str() {
        return "WELD-000624: Invalid type argument combination: {0}; {1}.";
    }
    @Override
    public final IllegalArgumentException invalidTypeArgumentCombination(final Type type1, final Type type2) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(invalidTypeArgumentCombination$str(), type1, type2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noSuchMethodWrapper$str() {
        return "WELD-000625: Unable to locate method: {0}";
    }
    @Override
    public final WeldException noSuchMethodWrapper(final NoSuchMethodException cause, final String message) {
        final WeldException result = new WeldException(_formatMessage(noSuchMethodWrapper$str(), message), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void catchingDebug(final Throwable throwable) {
        super.log.logf(FQCN, DEBUG, throwable, catchingDebug$str());
    }
    protected String catchingDebug$str() {
        return "Catching";
    }
}
