/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import jakarta.enterprise.inject.spi.Bean;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.function.Function;
import org.jboss.weld.Container;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bean.proxy.ClientProxyFactory;
import org.jboss.weld.bean.proxy.ContextBeanInstance;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.serialization.spi.BeanIdentifier;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.util.Proxies;
import org.jboss.weld.util.cache.ComputingCache;
import org.jboss.weld.util.cache.ComputingCacheBuilder;
import org.jboss.weld.util.collections.ImmutableSet;
import org.jboss.weld.util.reflection.Reflections;

public class ClientProxyProvider {
    private static final Object BEAN_NOT_PROXYABLE_MARKER = new Object();
    private final ComputingCache<Bean<Object>, Object> beanTypeClosureProxyPool;
    private final ComputingCache<RequestedTypeHolder, Object> requestedTypeClosureProxyPool;
    private final String contextId;
    private volatile ServiceRegistry services;

    public ClientProxyProvider(String contextId) {
        ComputingCacheBuilder cacheBuilder = ComputingCacheBuilder.newBuilder();
        this.beanTypeClosureProxyPool = cacheBuilder.build(new CreateClientProxy());
        this.requestedTypeClosureProxyPool = cacheBuilder.build(new CreateClientProxyForType());
        this.contextId = contextId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceRegistry services() {
        if (this.services == null) {
            ClientProxyProvider clientProxyProvider = this;
            synchronized (clientProxyProvider) {
                if (this.services == null) {
                    this.services = Container.instance(this.contextId).services();
                }
            }
        }
        return this.services;
    }

    private <T> T createClientProxy(Bean<T> bean) throws RuntimeException {
        return this.createClientProxy(bean, bean.getTypes());
    }

    private <T> T createClientProxy(Bean<T> bean, Set<Type> types) {
        BeanIdentifier id = ((ContextualStore)Container.instance(this.contextId).services().get(ContextualStore.class)).putIfAbsent(bean);
        if (id == null) {
            throw BeanLogger.LOG.beanIdCreationFailed(bean);
        }
        ContextBeanInstance<T> beanInstance = new ContextBeanInstance<T>(bean, id, this.contextId);
        Proxies.TypeInfo typeInfo = Proxies.TypeInfo.of(types);
        Object proxy = new ClientProxyFactory(this.contextId, typeInfo.getSuperClass(), types, bean).create(beanInstance);
        BeanLogger.LOG.createdNewClientProxyType(proxy.getClass(), bean, id);
        return proxy;
    }

    public <T> T getClientProxy(Bean<T> bean) {
        Object proxy = this.beanTypeClosureProxyPool.getCastValue(bean);
        if (proxy == BEAN_NOT_PROXYABLE_MARKER) {
            throw Proxies.getUnproxyableTypesException(bean, this.services());
        }
        BeanLogger.LOG.lookedUpClientProxy(proxy.getClass(), bean);
        return proxy;
    }

    public <T> T getClientProxy(Bean<T> bean, Type requestedType) {
        Object proxy = this.beanTypeClosureProxyPool.getCastValue(bean);
        if (proxy == BEAN_NOT_PROXYABLE_MARKER && (proxy = this.requestedTypeClosureProxyPool.getCastValue(new RequestedTypeHolder(requestedType, bean))) == BEAN_NOT_PROXYABLE_MARKER) {
            throw Proxies.getUnproxyableTypeException(requestedType, this.services());
        }
        BeanLogger.LOG.lookedUpClientProxy(proxy.getClass(), bean);
        return proxy;
    }

    public String toString() {
        return "Proxy pool with " + this.beanTypeClosureProxyPool.size() + " bean type proxies and " + this.requestedTypeClosureProxyPool.size() + "injection point type proxies.";
    }

    public void clear() {
        this.beanTypeClosureProxyPool.clear();
        this.requestedTypeClosureProxyPool.clear();
    }

    private class CreateClientProxy
    implements Function<Bean<Object>, Object> {
        private CreateClientProxy() {
        }

        @Override
        public Object apply(Bean<Object> from) {
            if (Proxies.isTypesProxyable(from, ClientProxyProvider.this.services())) {
                return ClientProxyProvider.this.createClientProxy(from);
            }
            return BEAN_NOT_PROXYABLE_MARKER;
        }
    }

    private class CreateClientProxyForType
    implements Function<RequestedTypeHolder, Object> {
        private CreateClientProxyForType() {
        }

        @Override
        public Object apply(RequestedTypeHolder input) {
            ImmutableSet.Builder<Type> types = ImmutableSet.builder();
            for (Type type : input.bean.getTypes()) {
                if (!Reflections.getRawType(type).isInterface()) continue;
                types.add(type);
            }
            if (input.requestedType.equals(Object.class)) {
                Class beanType;
                if (input.bean instanceof RIBean) {
                    RIBean riBean = (RIBean)input.bean;
                    beanType = riBean.getType();
                } else {
                    beanType = input.bean.getBeanClass();
                }
                if (Proxies.isTypeProxyable(beanType, ClientProxyProvider.this.services())) {
                    return ClientProxyProvider.this.createClientProxy(input.bean, types.add(beanType).build());
                }
            }
            if (Proxies.isTypeProxyable(input.requestedType, ClientProxyProvider.this.services())) {
                return ClientProxyProvider.this.createClientProxy(input.bean, types.add(input.requestedType).build());
            }
            Class requestedRawType = Reflections.getRawType(input.requestedType);
            for (Type type : input.bean.getTypes()) {
                if (!requestedRawType.isAssignableFrom(Reflections.getRawType(type)) || !Proxies.isTypeProxyable(type, ClientProxyProvider.this.services())) continue;
                return ClientProxyProvider.this.createClientProxy(input.bean, types.add(type).build());
            }
            return BEAN_NOT_PROXYABLE_MARKER;
        }
    }

    private static class RequestedTypeHolder {
        private final Type requestedType;
        private final Bean<?> bean;

        private RequestedTypeHolder(Type requestedType, Bean<?> bean) {
            this.requestedType = requestedType;
            this.bean = bean;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.bean == null ? 0 : this.bean.hashCode());
            result = 31 * result + (this.requestedType == null ? 0 : this.requestedType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RequestedTypeHolder other = (RequestedTypeHolder)obj;
            if (this.bean == null ? other.bean != null : !this.bean.equals(other.bean)) {
                return false;
            }
            return !(this.requestedType == null ? other.requestedType != null : !this.requestedType.equals(other.requestedType));
        }
    }
}

