/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resources;

import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.util.collections.ArraySetMultimap;
import org.jboss.weld.util.reflection.HierarchyDiscovery;
import org.jboss.weld.util.reflection.Reflections;

public class SharedObjectCache
implements Service {
    private final Map<Set<?>, Set<?>> sharedSets = new MapMaker().makeComputingMap(new Function<Set<?>, Set<?>>(){

        public Set<?> apply(Set<?> from) {
            return Collections.unmodifiableSet(from);
        }
    });
    private final Map<Map<?, ?>, Map<?, ?>> sharedMaps = new MapMaker().makeComputingMap(new Function<Map<?, ?>, Map<?, ?>>(){

        public Map<?, ?> apply(Map<?, ?> from) {
            return Collections.unmodifiableMap(from);
        }
    });
    private final Map<ArraySetMultimap<?, ?>, ArraySetMultimap<?, ?>> sharedMultiMaps = new MapMaker().makeComputingMap(new Function<ArraySetMultimap<?, ?>, ArraySetMultimap<?, ?>>(){

        public ArraySetMultimap<?, ?> apply(ArraySetMultimap<?, ?> from) {
            return from;
        }
    });
    private final Map<Type, Set<Type>> typeClosures = new MapMaker().makeComputingMap((Function)new Function<Type, Set<Type>>(){

        public Set<Type> apply(Type from) {
            return Collections.unmodifiableSet(new HierarchyDiscovery(from).getTypeClosure());
        }
    });
    private final Map<Type, Type> resolvedTypes = new MapMaker().makeComputingMap((Function)new Function<Type, Type>(){

        public Type apply(Type from) {
            return new HierarchyDiscovery(from).getResolvedType();
        }
    });

    public <T> Set<T> getSharedSet(Set<T> set) {
        return (Set)Reflections.cast(this.sharedSets.get(set));
    }

    public <K, V> Map<K, V> getSharedMap(Map<K, V> map) {
        return (Map)Reflections.cast(this.sharedMaps.get(map));
    }

    public <K, V> ArraySetMultimap<K, V> getSharedMultimap(ArraySetMultimap<K, V> map) {
        return (ArraySetMultimap)Reflections.cast(this.sharedMultiMaps.get(map));
    }

    public Set<Type> getTypeClosure(Type type) {
        return this.typeClosures.get(type);
    }

    public Type getResolvedType(Type type) {
        return this.resolvedTypes.get(type);
    }

    public void cleanup() {
        this.sharedSets.clear();
        this.sharedMaps.clear();
        this.sharedMultiMaps.clear();
    }
}

