/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.cache;

import com.google.common.cache.LoadingCache;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.logging.messages.UtilMessage;

public final class LoadingCacheUtils {
    private LoadingCacheUtils() {
    }

    public static <K, V> V getCacheValue(LoadingCache<K, V> cache, K key) {
        return LoadingCacheUtils.getCacheValue(cache, key, true);
    }

    public static <K, V> V getCacheValue(LoadingCache<K, V> cache, K key, boolean wrapExecutionProblem) {
        if (wrapExecutionProblem) {
            try {
                return (V)cache.get(key);
            }
            catch (Exception e) {
                throw new WeldException(UtilMessage.UNABLE_TO_LOAD_CACHE_VALUE, (Throwable)e, key);
            }
        }
        return (V)cache.getUnchecked(key);
    }

    public static <T, K, V> T getCastCacheValue(LoadingCache<K, V> cache, Object key) {
        return LoadingCacheUtils.getCastCacheValue(cache, key, true);
    }

    public static <T, K, V> T getCastCacheValue(LoadingCache<K, V> cache, Object key, boolean wrapExecutionProblem) {
        return (T)LoadingCacheUtils.getCacheValue(cache, key, wrapExecutionProblem);
    }
}

