/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MapMaker;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jboss.weld.resolution.Resolvable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypeSafeResolver<R extends Resolvable, T> {
    private final ConcurrentMap<R, Set<T>> resolved;
    private final Iterable<? extends T> allBeans;
    private final ResolvableToBeanSet<R, T> resolverFunction = new ResolvableToBeanSet(this);

    public TypeSafeResolver(Iterable<? extends T> allBeans) {
        this.resolved = new MapMaker().makeComputingMap(this.resolverFunction);
        this.allBeans = allBeans;
    }

    public void clear() {
        this.resolved.clear();
    }

    public Set<T> resolve(R resolvable, boolean cache) {
        R wrappedResolvable = this.wrap(resolvable);
        if (cache) {
            return (Set)this.resolved.get(wrappedResolvable);
        }
        return this.resolverFunction.apply(wrappedResolvable);
    }

    private Set<T> findMatching(R resolvable) {
        HashSet<T> result = new HashSet<T>();
        for (T bean : this.getAllBeans(resolvable)) {
            if (!this.matches(resolvable, bean)) continue;
            result.add(bean);
        }
        HashSet<T> iterable = result;
        return ImmutableSet.copyOf(iterable);
    }

    protected Iterable<? extends T> getAllBeans(R resolvable) {
        return this.allBeans;
    }

    protected Iterable<? extends T> getAllBeans() {
        return this.allBeans;
    }

    protected abstract Set<T> filterResult(Set<T> var1);

    protected abstract Set<T> sortResult(Set<T> var1);

    protected abstract boolean matches(R var1, T var2);

    protected R wrap(R resolvable) {
        return resolvable;
    }

    public boolean isCached(R resolvable) {
        return this.resolved.containsKey(this.wrap(resolvable));
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Resolver\n");
        buffer.append("Resolved injection points: " + this.resolved.size() + "\n");
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResolvableToBeanSet<R extends Resolvable, T>
    implements Function<R, Set<T>> {
        private final TypeSafeResolver<R, T> resolver;

        private ResolvableToBeanSet(TypeSafeResolver<R, T> resolver) {
            this.resolver = resolver;
        }

        public Set<T> apply(R from) {
            return this.resolver.sortResult(this.resolver.filterResult(((TypeSafeResolver)this.resolver).findMatching(from)));
        }
    }
}

