/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.inject.spi.ObserverMethod;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.event.TransactionalObserverNotifier;
import org.jboss.weld.literal.AnyLiteral;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.resolution.ResolvableBuilder;
import org.jboss.weld.resolution.TypeSafeObserverResolver;
import org.jboss.weld.resources.SharedObjectCache;
import org.jboss.weld.transaction.spi.TransactionServices;
import org.jboss.weld.util.Observers;
import org.jboss.weld.util.reflection.Reflections;

public class ObserverNotifier {
    private final TypeSafeObserverResolver resolver;
    protected final BeanManagerImpl beanManager;
    private final SharedObjectCache sharedObjectCache;

    public static ObserverNotifier of(TypeSafeObserverResolver resolver, BeanManagerImpl beanManager) {
        if (beanManager.getServices().contains(TransactionServices.class)) {
            return new TransactionalObserverNotifier(resolver, beanManager);
        }
        return new ObserverNotifier(resolver, beanManager);
    }

    protected ObserverNotifier(TypeSafeObserverResolver resolver, BeanManagerImpl beanManager) {
        this.resolver = resolver;
        this.beanManager = beanManager;
        ServiceRegistry services = beanManager.getServices();
        this.sharedObjectCache = (SharedObjectCache)services.get(SharedObjectCache.class);
    }

    public <T> Set<ObserverMethod<? super T>> resolveObserverMethods(T event, Annotation ... bindings) {
        Observers.checkEventObjectType(this.sharedObjectCache, event);
        return this.resolveObserverMethods((Type)event.getClass(), bindings);
    }

    public void fireEvent(Object event, Annotation ... qualifiers) {
        this.fireEvent(event.getClass(), event, qualifiers);
    }

    public void fireEvent(Type eventType, Object event, Annotation ... qualifiers) {
        Observers.checkEventObjectType(this.sharedObjectCache, event);
        this.notifyObservers(event, this.resolveObserverMethods(eventType, qualifiers));
    }

    public void fireEvent(Type eventType, Object event, Set<Annotation> qualifiers) {
        Observers.checkEventObjectType(this.sharedObjectCache, event);
        this.notifyObservers(event, this.resolveObserverMethods(eventType, qualifiers));
    }

    private <T> void notifyObservers(T event, Set<ObserverMethod<? super T>> observers) {
        for (ObserverMethod<T> observerMethod : observers) {
            this.notifyObserver(event, observerMethod);
        }
    }

    public <T> Set<ObserverMethod<? super T>> resolveObserverMethods(Type eventType, Annotation ... qualifiers) {
        Resolvable resolvable = new ResolvableBuilder(this.beanManager).addTypes(this.sharedObjectCache.getTypeClosure(eventType)).addType((Type)((Object)Object.class)).addQualifiers(qualifiers).addQualifierIfAbsent((Annotation)AnyLiteral.INSTANCE).create();
        return (Set)Reflections.cast(this.resolver.resolve(resolvable, true));
    }

    public <T> Set<ObserverMethod<? super T>> resolveObserverMethods(Type eventType, Set<Annotation> qualifiers) {
        Set<Type> typeClosure = this.sharedObjectCache.getTypeClosure(eventType);
        Resolvable resolvable = new ResolvableBuilder(this.beanManager).addTypes(typeClosure).addType((Type)((Object)Object.class)).addQualifiers(qualifiers).addQualifierIfAbsent((Annotation)AnyLiteral.INSTANCE).create();
        return (Set)Reflections.cast(this.resolver.resolve(resolvable, true));
    }

    public void clear() {
        this.resolver.clear();
    }

    protected <T> void notifyObserver(T event, ObserverMethod<? super T> observer) {
        observer.notify(event);
    }
}

