/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.builder;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.jboss.weld.interceptor.proxy.InterceptorException;
import org.jboss.weld.interceptor.spi.metadata.MethodMetadata;
import org.jboss.weld.interceptor.util.ReflectionUtils;

public class MethodReference
implements Serializable {
    private final String methodName;
    private final Class<?>[] parameterTypes;
    private final Class<?> declaringClass;

    public static MethodReference of(Method method, boolean withDeclaringClass) {
        return new MethodReference(method, withDeclaringClass);
    }

    public static MethodReference of(MethodMetadata method, boolean withDeclaringClass) {
        return new MethodReference(method.getJavaMethod(), withDeclaringClass);
    }

    private MethodReference(Method method, boolean withDeclaringClass) {
        this.methodName = method.getName();
        this.parameterTypes = method.getParameterTypes();
        this.declaringClass = withDeclaringClass ? method.getDeclaringClass() : null;
    }

    private MethodReference(String methodName, Class<?>[] parameterTypes, Class<?> declaringClass) {
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
        this.declaringClass = declaringClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodReference that = (MethodReference)o;
        if (this.declaringClass != null ? !this.declaringClass.equals(that.declaringClass) : that.declaringClass != null) {
            return false;
        }
        if (this.methodName != null ? !this.methodName.equals(that.methodName) : that.methodName != null) {
            return false;
        }
        return Arrays.equals(this.parameterTypes, that.parameterTypes);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public int hashCode() {
        int result = this.methodName != null ? this.methodName.hashCode() : 0;
        result = 31 * result + (this.parameterTypes != null ? Arrays.hashCode(this.parameterTypes) : 0);
        result = 31 * result + (this.declaringClass != null ? this.declaringClass.hashCode() : 0);
        return result;
    }

    private Object writeReplace() {
        return new MethodHolderSerializationProxy(this);
    }

    static class MethodHolderSerializationProxy
    implements Serializable {
        private final String className;
        private final String methodName;
        private String[] parameterClassNames;

        MethodHolderSerializationProxy(MethodReference methodReference) {
            this.className = methodReference.declaringClass != null ? methodReference.declaringClass.getName() : null;
            this.methodName = methodReference.methodName;
            if (methodReference.parameterTypes != null) {
                this.parameterClassNames = new String[methodReference.parameterTypes.length];
                int i = 0;
                for (Class parameterType : methodReference.parameterTypes) {
                    this.parameterClassNames[i++] = parameterType.getName();
                }
            }
        }

        private Object readResolve() {
            try {
                Class[] parameterTypes = null;
                if (this.parameterClassNames != null) {
                    parameterTypes = new Class[this.parameterClassNames.length];
                    for (int i = 0; i < this.parameterClassNames.length; ++i) {
                        parameterTypes[i] = ReflectionUtils.classForName(this.parameterClassNames[i]);
                    }
                }
                Class<?> declaringClass = null;
                if (this.className != null) {
                    declaringClass = ReflectionUtils.classForName(this.className);
                }
                return new MethodReference(this.methodName, parameterTypes, declaringClass);
            }
            catch (ClassNotFoundException e) {
                throw new InterceptorException("Error while deserializing intercepted instance", e);
            }
        }
    }
}

