/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resources;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.Container;
import org.jboss.weld.resources.SharedObjectCache;
import org.jboss.weld.util.collections.ArraySetMultimap;
import org.jboss.weld.util.reflection.HierarchyDiscovery;

public class SharedObjectFacade {
    private SharedObjectFacade() {
    }

    public static <T> Set<T> wrap(String contextId, Set<T> set) {
        SharedObjectCache cache = SharedObjectFacade.getSharedObjectCache(contextId);
        if (cache != null) {
            return cache.getSharedSet(set);
        }
        return set;
    }

    public static <K, V> Map<K, V> wrap(String contextId, Map<K, V> map) {
        SharedObjectCache cache = SharedObjectFacade.getSharedObjectCache(contextId);
        if (cache != null) {
            return ((SharedObjectCache)Container.instance(contextId).services().get(SharedObjectCache.class)).getSharedMap(map);
        }
        return map;
    }

    public static <K, V> ArraySetMultimap<K, V> wrap(String contextId, ArraySetMultimap<K, V> map) {
        SharedObjectCache cache = SharedObjectFacade.getSharedObjectCache(contextId);
        if (cache != null) {
            return ((SharedObjectCache)Container.instance(contextId).services().get(SharedObjectCache.class)).getSharedMultimap(map);
        }
        return map;
    }

    public static Set<Type> getTypeClosure(String contextId, Type type) {
        SharedObjectCache cache = SharedObjectFacade.getSharedObjectCache(contextId);
        if (cache != null) {
            return ((SharedObjectCache)Container.instance(contextId).services().get(SharedObjectCache.class)).getTypeClosure(type);
        }
        return new HierarchyDiscovery(type).getTypeClosure();
    }

    private static SharedObjectCache getSharedObjectCache(String contextId) {
        try {
            return (SharedObjectCache)Container.instance(contextId).services().get(SharedObjectCache.class);
        }
        catch (IllegalStateException e) {
            return null;
        }
    }
}

