/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.util.TypeLiteral;
import org.jboss.weld.Container;
import org.jboss.weld.ContainerState;
import org.jboss.weld.bean.builtin.BeanManagerProxy;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.logging.messages.BeanManagerMessage;
import org.jboss.weld.manager.BeanManagerImpl;

public class Weld
extends CDI<Object> {
    private final LoadingCache<String, BeanManagerProxy> beanManagers = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new ClassNameToBeanManager());
    private final Set<String> subclassNames;

    public Weld() {
        HashSet<String> names = new HashSet<String>();
        for (Class<?> clazz = ((Object)((Object)this)).getClass(); clazz != CDI.class; clazz = clazz.getSuperclass()) {
            names.add(clazz.getName());
        }
        this.subclassNames = Collections.unmodifiableSet(names);
    }

    protected BeanManagerImpl unsatisfiedBeanManager(String callerClassName) {
        throw new IllegalStateException(BeanManagerMessage.UNSATISFIED_BEAN_MANAGER, callerClassName);
    }

    protected BeanManagerImpl ambiguousBeanManager(String callerClassName, Set<BeanManagerImpl> managers) {
        throw new IllegalStateException(BeanManagerMessage.AMBIGUOUS_BEAN_MANAGER, callerClassName);
    }

    public BeanManagerProxy getBeanManager() {
        ContainerState state = Container.instance().getState();
        if (state.equals((Object)ContainerState.STOPPED) || state.equals((Object)ContainerState.SHUTDOWN)) {
            throw new IllegalStateException(BeanManagerMessage.BEAN_MANAGER_NOT_AVAILABLE, new Object[0]);
        }
        return (BeanManagerProxy)this.beanManagers.getUnchecked((Object)this.getCallingClassName());
    }

    protected String getCallingClassName() {
        boolean outerSubclassReached = false;
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!this.subclassNames.contains(element.getClassName())) {
                if (!outerSubclassReached) continue;
                return element.getClassName();
            }
            outerSubclassReached = true;
        }
        throw new IllegalStateException(BeanManagerMessage.UNABLE_TO_IDENTIFY_BEAN_MANAGER, new Object[0]);
    }

    public Iterator<Object> iterator() {
        return this.getInstance().iterator();
    }

    public Object get() {
        return this.getInstance().get();
    }

    public Instance<Object> select(Annotation ... qualifiers) {
        return this.getInstance().select(qualifiers);
    }

    public <U> Instance<U> select(Class<U> subtype, Annotation ... qualifiers) {
        return this.getInstance().select(subtype, qualifiers);
    }

    public <U> Instance<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
        return this.getInstance().select(subtype, qualifiers);
    }

    public boolean isUnsatisfied() {
        return this.getInstance().isUnsatisfied();
    }

    public boolean isAmbiguous() {
        return this.getInstance().isAmbiguous();
    }

    protected Instance<Object> getInstance() {
        return this.getBeanManager().delegate().instance();
    }

    public String toString() {
        return "Weld";
    }

    public void cleanup() {
        this.beanManagers.invalidateAll();
    }

    public void destroy(Object instance) {
        this.getInstance().destroy(instance);
    }

    private class ClassNameToBeanManager
    extends CacheLoader<String, BeanManagerProxy> {
        private ClassNameToBeanManager() {
        }

        public BeanManagerProxy load(String callerClassName) {
            return new BeanManagerProxy(this.findBeanManager(callerClassName));
        }

        public BeanManagerImpl findBeanManager(String callerClassName) {
            if (callerClassName == null) {
                throw new IllegalStateException(BeanManagerMessage.UNABLE_TO_IDENTIFY_BEAN_MANAGER, new Object[0]);
            }
            Container container = Container.instance();
            HashSet<BeanManagerImpl> managers = new HashSet<BeanManagerImpl>();
            for (Map.Entry<BeanDeploymentArchive, BeanManagerImpl> entry : container.beanDeploymentArchives().entrySet()) {
                for (String className : entry.getKey().getBeanClasses()) {
                    if (!className.equals(callerClassName)) continue;
                    managers.add(entry.getValue());
                }
            }
            if (managers.size() == 1) {
                return (BeanManagerImpl)managers.iterator().next();
            }
            if (managers.size() == 0) {
                return Weld.this.unsatisfiedBeanManager(callerClassName);
            }
            return Weld.this.ambiguousBeanManager(callerClassName, managers);
        }
    }
}

