/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.producer;

import java.io.Serializable;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMember;
import org.jboss.weld.bean.DisposalMethod;
import org.jboss.weld.context.WeldCreationalContext;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.injection.producer.AbstractProducer;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.slf4j.cal10n.LocLogger;

public abstract class AbstractMemberProducer<X, T>
extends AbstractProducer<T> {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BEAN);
    private final DisposalMethod<?, ?> disposalMethod;

    public AbstractMemberProducer(EnhancedAnnotatedMember<T, ? super X, ? extends Member> enhancedMember, DisposalMethod<?, ?> disposalMethod) {
        this.disposalMethod = disposalMethod;
        this.checkDeclaringBean();
        this.checkProducerReturnType(enhancedMember);
    }

    protected void checkDeclaringBean() {
        if (this.getDeclaringBean() == null && !this.getAnnotated().isStatic()) {
            throw new IllegalArgumentException(BeanMessage.DECLARING_BEAN_MISSING, this.getAnnotated());
        }
    }

    protected void checkProducerReturnType(EnhancedAnnotatedMember<T, ? super X, ? extends Member> enhancedMember) {
        if (enhancedMember.getBaseType() instanceof TypeVariable || enhancedMember.getBaseType() instanceof WildcardType) {
            throw new DefinitionException(BeanMessage.RETURN_TYPE_MUST_BE_CONCRETE, enhancedMember.getBaseType());
        }
        if (enhancedMember.isParameterizedType()) {
            boolean dependent = this.getBean() != null && Dependent.class.equals((Object)this.getBean().getScope());
            for (Type type : enhancedMember.getActualTypeArguments()) {
                if (!dependent && type instanceof TypeVariable) {
                    throw new DefinitionException(BeanMessage.PRODUCER_METHOD_WITH_TYPE_VARIABLE_RETURN_TYPE_MUST_BE_DEPENDENT, enhancedMember);
                }
                if (!(type instanceof WildcardType)) continue;
                throw new DefinitionException(BeanMessage.PRODUCER_METHOD_CANNOT_HAVE_A_WILDCARD_RETURN_TYPE, enhancedMember);
            }
        }
    }

    protected Object getReceiver(CreationalContext<?> productCreationalContext, CreationalContext<?> receiverCreationalContext) {
        WeldCreationalContext creationalContextImpl;
        X incompleteInstance;
        if (this.getAnnotated().isStatic()) {
            return null;
        }
        if (productCreationalContext instanceof WeldCreationalContext && (incompleteInstance = (creationalContextImpl = (WeldCreationalContext)productCreationalContext).getIncompleteInstance(this.getDeclaringBean())) != null) {
            log.warn((Enum)BeanMessage.CIRCULAR_CALL, new Object[]{this.getAnnotated(), this.getDeclaringBean()});
            return incompleteInstance;
        }
        return this.getBeanManager().getReference(this.getDeclaringBean(), null, receiverCreationalContext, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(T instance) {
        if (this.disposalMethod != null) {
            org.jboss.weld.construction.api.WeldCreationalContext ctx = this.getBeanManager().createCreationalContext((Contextual)null);
            try {
                Object receiver = this.getReceiver((CreationalContext<?>)ctx, (CreationalContext<?>)ctx);
                this.disposalMethod.invokeDisposeMethod(receiver, instance, (CreationalContext<?>)ctx);
            }
            finally {
                ctx.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T produce(CreationalContext<T> ctx) {
        org.jboss.weld.construction.api.WeldCreationalContext receiverCreationalContext = this.getBeanManager().createCreationalContext((Contextual)this.getDeclaringBean());
        Object receiver = this.getReceiver(ctx, (CreationalContext<?>)receiverCreationalContext);
        try {
            T t = this.produce(receiver, ctx);
            return t;
        }
        finally {
            receiverCreationalContext.release();
        }
    }

    public DisposalMethod<?, ?> getDisposalMethod() {
        return this.disposalMethod;
    }

    protected boolean isTypeSerializable(Object object) {
        return object instanceof Serializable;
    }

    public abstract BeanManagerImpl getBeanManager();

    public abstract Bean<X> getDeclaringBean();

    @Override
    public abstract Bean<T> getBean();

    public abstract AnnotatedMember<? super X> getAnnotated();

    protected abstract T produce(Object var1, CreationalContext<T> var2);

    public String toString() {
        StringBuilder result = new StringBuilder("Producer for ");
        if (this.getDeclaringBean() == null) {
            result.append(this.getAnnotated());
        } else {
            if (this.getBean() == null) {
                result.append(this.getAnnotated());
            } else {
                result.append(this.getBean());
            }
            result.append(" declared on " + this.getDeclaringBean());
        }
        return result.toString();
    }
}

