/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.producer;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.interceptor.InvocationContext;
import org.jboss.weld.construction.api.AroundConstructCallback;
import org.jboss.weld.construction.api.ConstructionHandle;
import org.jboss.weld.context.CreationalContextImpl;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.injection.producer.ForwardingInstantiator;
import org.jboss.weld.injection.producer.Instantiator;
import org.jboss.weld.interceptor.proxy.InterceptionContext;
import org.jboss.weld.interceptor.proxy.InterceptorInvocation;
import org.jboss.weld.interceptor.proxy.InterceptorInvocationContext;
import org.jboss.weld.interceptor.proxy.SimpleInterceptionChain;
import org.jboss.weld.interceptor.spi.metadata.ClassMetadata;
import org.jboss.weld.interceptor.spi.metadata.InterceptorMetadata;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.interceptor.spi.model.InterceptionType;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.reflection.Reflections;

public class ConstructorInterceptionInstantiator<T>
extends ForwardingInstantiator<T> {
    private final InterceptionModel<ClassMetadata<?>> model;

    public ConstructorInterceptionInstantiator(Instantiator<T> delegate, InterceptionModel<ClassMetadata<?>> model) {
        super(delegate);
        this.model = model;
    }

    @Override
    public T newInstance(CreationalContext<T> ctx, BeanManagerImpl manager) {
        CreationalContextImpl weldCtx;
        if (ctx instanceof CreationalContextImpl && !(weldCtx = (CreationalContextImpl)Reflections.cast(ctx)).isConstructorInterceptionSuppressed()) {
            this.registerAroundConstructCallback(weldCtx, manager);
        }
        return this.delegate().newInstance(ctx, manager);
    }

    private void registerAroundConstructCallback(CreationalContextImpl<T> ctx, BeanManagerImpl manager) {
        InterceptionContext interceptionContext = InterceptionContext.forConstructorInterception(this.model, ctx, manager);
        final ArrayList<InterceptorInvocation> interceptorInvocations = new ArrayList<InterceptorInvocation>(this.model.getConstructorInvocationInterceptors().size());
        for (InterceptorMetadata<?> interceptorMetadata : this.model.getConstructorInvocationInterceptors()) {
            interceptorInvocations.add(interceptorMetadata.getInterceptorInvocation(interceptionContext.getInterceptorInstance(interceptorMetadata), InterceptionType.AROUND_CONSTRUCT));
        }
        AroundConstructCallback callback = new AroundConstructCallback<T>(){

            public T aroundConstruct(final ConstructionHandle<T> handle, AnnotatedConstructor<T> constructor, Object[] parameters, Map<String, Object> data) {
                final AtomicReference target = new AtomicReference();
                SimpleInterceptionChain chain = new SimpleInterceptionChain(interceptorInvocations){

                    @Override
                    protected Object interceptorChainCompleted(InvocationContext invocationCtx) throws Exception {
                        Object instance = handle.proceed(invocationCtx.getParameters(), invocationCtx.getContextData());
                        target.set(instance);
                        return null;
                    }
                };
                InterceptorInvocationContext invocationCtx = new InterceptorInvocationContext(chain, constructor.getJavaMember(), parameters, data){

                    @Override
                    public Object getTarget() {
                        return target.get();
                    }
                };
                try {
                    chain.invokeNextInterceptor(invocationCtx);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new WeldException(e);
                }
                return target.get();
            }
        };
        ctx.registerAroundConstructCallback(callback);
    }

    public String toString() {
        return "ConstructorInterceptionInstantiator wrapping " + this.delegate();
    }
}

