/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resources;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.Container;
import org.jboss.weld.annotated.enhanced.TypeClosureLazyValueHolder;
import org.jboss.weld.resources.SharedObjectCache;
import org.jboss.weld.util.LazyValueHolder;
import org.jboss.weld.util.collections.ArraySetMultimap;

public class SharedObjectFacade {
    private SharedObjectFacade() {
    }

    public static <T> Set<T> wrap(Set<T> set) {
        SharedObjectCache cache = SharedObjectFacade.getSharedObjectCache();
        if (cache != null) {
            return cache.getSharedSet(set);
        }
        return set;
    }

    public static <K, V> Map<K, V> wrap(Map<K, V> map) {
        SharedObjectCache cache = SharedObjectFacade.getSharedObjectCache();
        if (cache != null) {
            return ((SharedObjectCache)Container.instance().services().get(SharedObjectCache.class)).getSharedMap(map);
        }
        return map;
    }

    public static <K, V> ArraySetMultimap<K, V> wrap(ArraySetMultimap<K, V> map) {
        SharedObjectCache cache = SharedObjectFacade.getSharedObjectCache();
        if (cache != null) {
            return ((SharedObjectCache)Container.instance().services().get(SharedObjectCache.class)).getSharedMultimap(map);
        }
        return map;
    }

    public static LazyValueHolder<Set<Type>> getTypeClosureHolder(Type type) {
        SharedObjectCache cache = SharedObjectFacade.getSharedObjectCache();
        if (cache != null) {
            return ((SharedObjectCache)Container.instance().services().get(SharedObjectCache.class)).getTypeClosureHolder(type);
        }
        return new TypeClosureLazyValueHolder(type);
    }

    private static SharedObjectCache getSharedObjectCache() {
        try {
            return (SharedObjectCache)Container.instance().services().get(SharedObjectCache.class);
        }
        catch (IllegalStateException e) {
            return null;
        }
    }
}

