/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.Container;
import org.jboss.weld.bean.proxy.ClientProxyFactory;
import org.jboss.weld.bean.proxy.ContextBeanInstance;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.util.Proxies;
import org.jboss.weld.util.cache.LoadingCacheUtils;
import org.slf4j.cal10n.LocLogger;

public class ClientProxyProvider {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BEAN);
    private static final Object BEAN_NOT_PROXYABLE_MARKER = new Object();
    private static final CacheLoader<Bean<Object>, Object> CREATE_BEAN_TYPE_CLOSURE_CLIENT_PROXY = new CacheLoader<Bean<Object>, Object>(){

        public Object load(Bean<Object> from) {
            if (Proxies.isTypesProxyable(from)) {
                return ClientProxyProvider.createClientProxy(from);
            }
            return BEAN_NOT_PROXYABLE_MARKER;
        }
    };
    private static final CacheLoader<RequestedTypeHolder, Object> CREATE_REQUESTED_TYPE_CLOSURE_CLIENT_PROXY = new CacheLoader<RequestedTypeHolder, Object>(){

        public Object load(RequestedTypeHolder input) {
            if (Proxies.isTypeProxyable(input.requestedType)) {
                return ClientProxyProvider.createClientProxy(input.bean, Collections.singleton(input.requestedType));
            }
            return BEAN_NOT_PROXYABLE_MARKER;
        }
    };
    private final LoadingCache<Bean<Object>, Object> beanTypeClosureProxyPool;
    private final LoadingCache<RequestedTypeHolder, Object> requestedTypeClosureProxyPool;

    public ClientProxyProvider() {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        this.beanTypeClosureProxyPool = cacheBuilder.build(CREATE_BEAN_TYPE_CLOSURE_CLIENT_PROXY);
        this.requestedTypeClosureProxyPool = cacheBuilder.build(CREATE_REQUESTED_TYPE_CLOSURE_CLIENT_PROXY);
    }

    private static <T> T createClientProxy(Bean<T> bean) throws RuntimeException {
        return ClientProxyProvider.createClientProxy(bean, bean.getTypes());
    }

    private static <T> T createClientProxy(Bean<T> bean, Set<Type> types) {
        String id = ((ContextualStore)Container.instance().services().get(ContextualStore.class)).putIfAbsent(bean);
        if (id == null) {
            throw new DefinitionException(BeanMessage.BEAN_ID_CREATION_FAILED, bean);
        }
        ContextBeanInstance<T> beanInstance = new ContextBeanInstance<T>(bean, id);
        Proxies.TypeInfo typeInfo = Proxies.TypeInfo.of(types);
        Object proxy = new ClientProxyFactory(typeInfo.getSuperClass(), types, bean).create(beanInstance);
        log.trace((Enum)BeanMessage.CREATED_NEW_CLIENT_PROXY_TYPE, new Object[]{proxy.getClass(), bean, id});
        return proxy;
    }

    public <T> T getClientProxy(Bean<T> bean) {
        Object proxy = LoadingCacheUtils.getCastCacheValue(this.beanTypeClosureProxyPool, bean);
        if (proxy == BEAN_NOT_PROXYABLE_MARKER) {
            throw Proxies.getUnproxyableTypesException(bean);
        }
        log.trace((Enum)BeanMessage.LOOKED_UP_CLIENT_PROXY, new Object[]{proxy.getClass(), bean});
        return proxy;
    }

    public <T> T getClientProxy(Bean<T> bean, Type requestedType) {
        Object proxy = LoadingCacheUtils.getCastCacheValue(this.beanTypeClosureProxyPool, bean);
        if (proxy == BEAN_NOT_PROXYABLE_MARKER && (proxy = LoadingCacheUtils.getCastCacheValue(this.requestedTypeClosureProxyPool, new RequestedTypeHolder(requestedType, bean))) == BEAN_NOT_PROXYABLE_MARKER) {
            throw Proxies.getUnproxyableTypeException(requestedType);
        }
        log.trace((Enum)BeanMessage.LOOKED_UP_CLIENT_PROXY, new Object[]{proxy.getClass(), bean});
        return proxy;
    }

    public String toString() {
        return "Proxy pool with " + this.beanTypeClosureProxyPool.size() + " bean type proxies and " + this.requestedTypeClosureProxyPool.size() + "injection point type proxies.";
    }

    public void clear() {
        this.beanTypeClosureProxyPool.invalidateAll();
        this.requestedTypeClosureProxyPool.invalidateAll();
    }

    private static class RequestedTypeHolder {
        private final Type requestedType;
        private final Bean<?> bean;

        private RequestedTypeHolder(Type requestedType, Bean<?> bean) {
            this.requestedType = requestedType;
            this.bean = bean;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.bean == null ? 0 : this.bean.hashCode());
            result = 31 * result + (this.requestedType == null ? 0 : this.requestedType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RequestedTypeHolder other = (RequestedTypeHolder)obj;
            if (this.bean == null ? other.bean != null : !this.bean.equals(other.bean)) {
                return false;
            }
            return !(this.requestedType == null ? other.requestedType != null : !this.requestedType.equals(other.requestedType));
        }
    }
}

