/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.servlet;

import java.lang.annotation.Annotation;
import javax.servlet.http.HttpServletRequest;
import org.jboss.weld.context.ConversationContext;
import org.jboss.weld.context.http.HttpConversationContext;
import org.jboss.weld.literal.DestroyedLiteral;
import org.jboss.weld.literal.InitializedLiteral;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.ConversationMessage;
import org.jboss.weld.logging.messages.JsfMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.slf4j.cal10n.LocLogger;

public class ConversationContextActivator {
    private static final String NO_CID = "nocid";
    private static final String CONVERSATION_PROPAGATION = "conversationPropagation";
    private static final String CONVERSATION_PROPAGATION_NONE = "none";
    private static final String CONTEXT_ACTIVATED_IN_REQUEST = ConversationContextActivator.class.getName() + "CONTEXT_ACTIVATED_IN_REQUEST";
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.SERVLET);
    private final BeanManagerImpl beanManager;
    private HttpConversationContext httpConversationContextCache;

    protected ConversationContextActivator(BeanManagerImpl beanManager) {
        this.beanManager = beanManager;
    }

    private HttpConversationContext httpConversationContext() {
        if (this.httpConversationContextCache == null) {
            this.httpConversationContextCache = (HttpConversationContext)this.beanManager.instance().select(HttpConversationContext.class, new Annotation[0]).get();
        }
        return this.httpConversationContextCache;
    }

    public void startConversationContext(HttpServletRequest request) {
        this.associateConversationContext(request);
        this.activateConversationContext(request);
    }

    public void stopConversationContext(HttpServletRequest request) {
        this.deactivateConversationContext(request);
    }

    protected void activateConversationContext(HttpServletRequest request) {
        HttpConversationContext conversationContext = this.httpConversationContext();
        String cid = ConversationContextActivator.getConversationId(request, (ConversationContext)this.httpConversationContext());
        log.debug((Enum)JsfMessage.RESUMING_CONVERSATION, new Object[]{cid});
        if (!this.isContextActivatedInRequest(request)) {
            this.setContextActivatedInRequest(request);
            conversationContext.activate(cid);
            if (cid == null) {
                this.beanManager.getAccessibleLenientObserverNotifier().fireEvent((Object)request, new Annotation[]{InitializedLiteral.CONVERSATION});
            }
        } else {
            conversationContext.dissociate((Object)request);
            conversationContext.associate((Object)request);
            conversationContext.activate(cid);
        }
    }

    protected void associateConversationContext(HttpServletRequest request) {
        this.httpConversationContext().associate((Object)request);
    }

    private static String getConversationId(HttpServletRequest request, ConversationContext conversationContext) {
        if (request.getParameter(NO_CID) != null) {
            return null;
        }
        if (CONVERSATION_PROPAGATION_NONE.equals(request.getParameter(CONVERSATION_PROPAGATION))) {
            return null;
        }
        String cidName = conversationContext.getParameterName();
        String cid = request.getParameter(cidName);
        log.trace((Enum)JsfMessage.FOUND_CONVERSATION_FROM_REQUEST, new Object[]{cid});
        return cid;
    }

    private void setContextActivatedInRequest(HttpServletRequest request) {
        request.setAttribute(CONTEXT_ACTIVATED_IN_REQUEST, (Object)true);
    }

    private boolean isContextActivatedInRequest(HttpServletRequest request) {
        Object result = request.getAttribute(CONTEXT_ACTIVATED_IN_REQUEST);
        if (result == null) {
            return false;
        }
        return (Boolean)result;
    }

    protected void deactivateConversationContext(HttpServletRequest request) {
        HttpConversationContext conversationContext = this.httpConversationContext();
        if (conversationContext.isActive()) {
            boolean isTransient = conversationContext.getCurrentConversation().isTransient();
            if (log.isTraceEnabled()) {
                if (isTransient) {
                    log.trace((Enum)ConversationMessage.CLEANING_UP_TRANSIENT_CONVERSATION, new Object[0]);
                } else {
                    log.trace((Enum)JsfMessage.CLEANING_UP_CONVERSATION, new Object[]{conversationContext.getCurrentConversation().getId()});
                }
            }
            conversationContext.invalidate();
            conversationContext.deactivate();
            if (isTransient) {
                this.beanManager.getAccessibleLenientObserverNotifier().fireEvent((Object)request, new Annotation[]{DestroyedLiteral.CONVERSATION});
            }
        }
    }

    protected void disassociateConversationContext(HttpServletRequest request) {
        this.httpConversationContext().dissociate((Object)request);
    }
}

