/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.producer;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Interceptor;
import javax.interceptor.ExcludeClassInterceptors;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.config.WeldConfiguration;
import org.jboss.weld.ejb.EJBApiAbstraction;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.interceptor.builder.InterceptionModelBuilder;
import org.jboss.weld.interceptor.builder.InterceptorsApiAbstraction;
import org.jboss.weld.interceptor.reader.InterceptorMetadataReader;
import org.jboss.weld.interceptor.reader.TargetClassInterceptorMetadata;
import org.jboss.weld.interceptor.spi.metadata.InterceptorClassMetadata;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.interceptor.spi.model.InterceptionType;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.logging.ValidatorLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.Interceptors;
import org.jboss.weld.util.collections.ImmutableList;
import org.jboss.weld.util.collections.ImmutableSet;
import org.jboss.weld.util.collections.Iterables;
import org.jboss.weld.util.reflection.Reflections;

public class InterceptionModelInitializer<T> {
    private final BeanManagerImpl manager;
    private final InterceptorMetadataReader reader;
    private final EnhancedAnnotatedType<T> annotatedType;
    private final Set<Class<? extends Annotation>> stereotypes;
    private final AnnotatedConstructor<T> constructor;
    private final InterceptorsApiAbstraction interceptorsApi;
    private final EJBApiAbstraction ejbApi;
    private List<AnnotatedMethod<?>> businessMethods;
    private final InterceptionModelBuilder builder;
    private boolean hasSerializationOrInvocationInterceptorMethods;
    private final WeldConfiguration configuration;

    public static <T> InterceptionModelInitializer<T> of(BeanManagerImpl manager, EnhancedAnnotatedType<T> annotatedType, Bean<?> bean) {
        return new InterceptionModelInitializer<T>(manager, annotatedType, Beans.getBeanConstructorStrict(annotatedType), bean);
    }

    public InterceptionModelInitializer(BeanManagerImpl manager, EnhancedAnnotatedType<T> annotatedType, AnnotatedConstructor<T> constructor, Bean<?> bean) {
        this.constructor = constructor;
        this.manager = manager;
        this.reader = manager.getInterceptorMetadataReader();
        this.annotatedType = annotatedType;
        this.builder = new InterceptionModelBuilder();
        this.stereotypes = bean == null ? Collections.emptySet() : bean.getStereotypes();
        this.interceptorsApi = (InterceptorsApiAbstraction)manager.getServices().get(InterceptorsApiAbstraction.class);
        this.ejbApi = (EJBApiAbstraction)manager.getServices().get(EJBApiAbstraction.class);
        this.configuration = (WeldConfiguration)manager.getServices().get(WeldConfiguration.class);
    }

    public void init() {
        this.initTargetClassInterceptors();
        this.businessMethods = Beans.getInterceptableMethods(this.annotatedType);
        this.initEjbInterceptors();
        this.initCdiInterceptors();
        InterceptionModel interceptionModel = this.builder.build();
        if (interceptionModel.getAllInterceptors().size() > 0 || this.hasSerializationOrInvocationInterceptorMethods) {
            if (this.annotatedType.isFinal()) {
                throw BeanLogger.LOG.finalBeanClassWithInterceptorsNotAllowed(this.annotatedType.getJavaClass());
            }
            if (Reflections.isPrivate(this.constructor.getJavaMember())) {
                throw new DeploymentException(ValidatorLogger.LOG.notProxyablePrivateConstructor(this.annotatedType.getJavaClass(), this.constructor, this.annotatedType.getJavaClass()));
            }
            this.manager.getInterceptorModelRegistry().put(this.annotatedType.slim(), interceptionModel);
        }
    }

    private void initTargetClassInterceptors() {
        if (!Beans.isInterceptor(this.annotatedType)) {
            TargetClassInterceptorMetadata interceptorClassMetadata = this.reader.getTargetClassInterceptorMetadata(this.annotatedType);
            this.builder.setTargetClassInterceptorMetadata(interceptorClassMetadata);
            this.hasSerializationOrInvocationInterceptorMethods = interceptorClassMetadata.isEligible(InterceptionType.AROUND_INVOKE) || interceptorClassMetadata.isEligible(InterceptionType.AROUND_TIMEOUT) || interceptorClassMetadata.isEligible(InterceptionType.PRE_PASSIVATE) || interceptorClassMetadata.isEligible(InterceptionType.POST_ACTIVATE);
        } else {
            this.hasSerializationOrInvocationInterceptorMethods = false;
        }
    }

    private void initCdiInterceptors() {
        Map<Class<? extends Annotation>, Annotation> classBindingAnnotations = this.getClassInterceptorBindings();
        this.builder.setClassInterceptorBindings(ImmutableSet.copyOf(classBindingAnnotations.values()));
        this.initCdiLifecycleInterceptors(classBindingAnnotations);
        this.initCdiConstructorInterceptors(classBindingAnnotations);
        this.initCdiBusinessMethodInterceptors(classBindingAnnotations);
    }

    private Map<Class<? extends Annotation>, Annotation> getClassInterceptorBindings() {
        return Interceptors.mergeBeanInterceptorBindings(this.manager, this.annotatedType, this.stereotypes);
    }

    private void initCdiLifecycleInterceptors(Map<Class<? extends Annotation>, Annotation> classBindingAnnotations) {
        if (classBindingAnnotations.size() == 0) {
            return;
        }
        Set<Annotation> qualifiers = ImmutableSet.copyOf(classBindingAnnotations.values());
        this.initLifeCycleInterceptor(javax.enterprise.inject.spi.InterceptionType.POST_CONSTRUCT, null, qualifiers);
        this.initLifeCycleInterceptor(javax.enterprise.inject.spi.InterceptionType.PRE_DESTROY, null, qualifiers);
        this.initLifeCycleInterceptor(javax.enterprise.inject.spi.InterceptionType.PRE_PASSIVATE, null, qualifiers);
        this.initLifeCycleInterceptor(javax.enterprise.inject.spi.InterceptionType.POST_ACTIVATE, null, qualifiers);
    }

    private void initLifeCycleInterceptor(javax.enterprise.inject.spi.InterceptionType interceptionType, AnnotatedConstructor<?> constructor, Set<Annotation> annotations) {
        List<Interceptor<?>> resolvedInterceptors = this.manager.resolveInterceptors(interceptionType, annotations);
        if (!resolvedInterceptors.isEmpty()) {
            if (constructor != null) {
                this.builder.interceptGlobal(interceptionType, constructor.getJavaMember(), this.asInterceptorMetadata(resolvedInterceptors), annotations);
            } else {
                this.builder.interceptGlobal(interceptionType, null, this.asInterceptorMetadata(resolvedInterceptors), null);
            }
        }
    }

    private void initCdiBusinessMethodInterceptors(Map<Class<? extends Annotation>, Annotation> classBindingAnnotations) {
        for (AnnotatedMethod<?> method : this.businessMethods) {
            this.initCdiBusinessMethodInterceptor(method, this.getMemberBindingAnnotations(classBindingAnnotations, method.getAnnotations()));
        }
    }

    private void initCdiBusinessMethodInterceptor(AnnotatedMethod<?> method, Set<Annotation> methodBindingAnnotations) {
        if (methodBindingAnnotations.size() == 0) {
            return;
        }
        this.initInterceptor(javax.enterprise.inject.spi.InterceptionType.AROUND_INVOKE, method, methodBindingAnnotations);
        this.initInterceptor(javax.enterprise.inject.spi.InterceptionType.AROUND_TIMEOUT, method, methodBindingAnnotations);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initInterceptor(javax.enterprise.inject.spi.InterceptionType interceptionType, AnnotatedMethod<?> method, Set<Annotation> methodBindingAnnotations) {
        List<Interceptor<?>> methodBoundInterceptors = this.manager.resolveInterceptors(interceptionType, methodBindingAnnotations);
        if (methodBoundInterceptors == null || methodBoundInterceptors.size() <= 0) return;
        Method javaMethod = method.getJavaMember();
        if (Reflections.isFinal(javaMethod)) {
            if (!this.configuration.isFinalMethodIgnored(javaMethod.getDeclaringClass().getName())) throw BeanLogger.LOG.finalInterceptedBeanMethodNotAllowed(method, methodBoundInterceptors.get(0).getBeanClass().getName());
            BeanLogger.LOG.finalMethodNotIntercepted(javaMethod, methodBoundInterceptors.get(0).getBeanClass().getName());
            return;
        } else {
            this.builder.interceptMethod(interceptionType, javaMethod, this.asInterceptorMetadata(methodBoundInterceptors), methodBindingAnnotations);
        }
    }

    private void initCdiConstructorInterceptors(Map<Class<? extends Annotation>, Annotation> classBindingAnnotations) {
        Set<Annotation> constructorBindings = this.getMemberBindingAnnotations(classBindingAnnotations, this.constructor.getAnnotations());
        if (constructorBindings.isEmpty()) {
            return;
        }
        this.initLifeCycleInterceptor(javax.enterprise.inject.spi.InterceptionType.AROUND_CONSTRUCT, this.constructor, constructorBindings);
    }

    private Set<Annotation> getMemberBindingAnnotations(Map<Class<? extends Annotation>, Annotation> classBindingAnnotations, Set<Annotation> memberAnnotations) {
        Set<Annotation> methodBindingAnnotations = Interceptors.flattenInterceptorBindings(this.manager, Interceptors.filterInterceptorBindings(this.manager, memberAnnotations), true, true);
        return ImmutableSet.copyOf(this.mergeMethodInterceptorBindings(classBindingAnnotations, methodBindingAnnotations).values());
    }

    private void initEjbInterceptors() {
        this.initClassDeclaredEjbInterceptors();
        this.initConstructorDeclaredEjbInterceptors();
        for (AnnotatedMethod<?> method : this.businessMethods) {
            this.initMethodDeclaredEjbInterceptors(method);
        }
    }

    private void initClassDeclaredEjbInterceptors() {
        Class<?>[] classDeclaredInterceptors = this.interceptorsApi.extractInterceptorClasses(this.annotatedType);
        boolean excludeClassLevelAroundConstructInterceptors = this.constructor.isAnnotationPresent(ExcludeClassInterceptors.class);
        if (classDeclaredInterceptors != null) {
            for (Class<?> clazz : classDeclaredInterceptors) {
                InterceptorClassMetadata<?> interceptor = this.reader.getPlainInterceptorMetadata(clazz);
                for (javax.enterprise.inject.spi.InterceptionType interceptionType : javax.enterprise.inject.spi.InterceptionType.values()) {
                    if (excludeClassLevelAroundConstructInterceptors && interceptionType.equals((Object)javax.enterprise.inject.spi.InterceptionType.AROUND_CONSTRUCT) || !interceptor.isEligible(InterceptionType.valueOf(interceptionType))) continue;
                    this.builder.interceptGlobal(interceptionType, null, Collections.singleton(interceptor), null);
                }
            }
        }
    }

    public void initConstructorDeclaredEjbInterceptors() {
        Class<?>[] constructorDeclaredInterceptors = this.interceptorsApi.extractInterceptorClasses((Annotated)this.constructor);
        if (constructorDeclaredInterceptors != null) {
            for (Class<?> clazz : constructorDeclaredInterceptors) {
                this.builder.interceptGlobal(javax.enterprise.inject.spi.InterceptionType.AROUND_CONSTRUCT, null, Collections.singleton(this.reader.getPlainInterceptorMetadata(clazz)), null);
            }
        }
    }

    private void initMethodDeclaredEjbInterceptors(AnnotatedMethod<?> method) {
        Class<?>[] methodDeclaredInterceptors;
        Method javaMethod = method.getJavaMember();
        boolean excludeClassInterceptors = method.isAnnotationPresent(this.interceptorsApi.getExcludeClassInterceptorsAnnotationClass());
        if (excludeClassInterceptors) {
            this.builder.addMethodIgnoringGlobalInterceptors(javaMethod);
        }
        if ((methodDeclaredInterceptors = this.interceptorsApi.extractInterceptorClasses((Annotated)method)) != null && methodDeclaredInterceptors.length > 0) {
            if (Reflections.isFinal(method.getJavaMember())) {
                throw new DeploymentException((Throwable)((Object)BeanLogger.LOG.finalInterceptedBeanMethodNotAllowed(method, methodDeclaredInterceptors[0].getName())));
            }
            javax.enterprise.inject.spi.InterceptionType interceptionType = this.isTimeoutAnnotationPresentOn(method) ? javax.enterprise.inject.spi.InterceptionType.AROUND_TIMEOUT : javax.enterprise.inject.spi.InterceptionType.AROUND_INVOKE;
            this.builder.interceptMethod(interceptionType, javaMethod, this.getMethodDeclaredInterceptorMetadatas(methodDeclaredInterceptors), null);
        }
    }

    private List<InterceptorClassMetadata<?>> getMethodDeclaredInterceptorMetadatas(Class<?>[] methodDeclaredInterceptors) {
        LinkedList list = new LinkedList();
        for (Class<?> clazz : methodDeclaredInterceptors) {
            list.add(this.reader.getPlainInterceptorMetadata(clazz));
        }
        return list;
    }

    private boolean isTimeoutAnnotationPresentOn(AnnotatedMethod<?> method) {
        return method.isAnnotationPresent(this.ejbApi.TIMEOUT_ANNOTATION_CLASS);
    }

    protected Map<Class<? extends Annotation>, Annotation> mergeMethodInterceptorBindings(Map<Class<? extends Annotation>, Annotation> beanBindings, Set<Annotation> methodBindingAnnotations) {
        HashMap<Class<? extends Annotation>, Annotation> mergedBeanBindings = new HashMap<Class<? extends Annotation>, Annotation>(beanBindings);
        HashSet<Class<? extends Annotation>> processedBindingTypes = new HashSet<Class<? extends Annotation>>();
        for (Annotation methodBinding : methodBindingAnnotations) {
            Class<? extends Annotation> methodBindingType = methodBinding.annotationType();
            if (processedBindingTypes.contains(methodBindingType)) {
                throw new DeploymentException(BeanLogger.LOG.conflictingInterceptorBindings(this.annotatedType));
            }
            processedBindingTypes.add(methodBindingType);
            mergedBeanBindings.put(methodBindingType, methodBinding);
        }
        return mergedBeanBindings;
    }

    private List<InterceptorClassMetadata<?>> asInterceptorMetadata(List<Interceptor<?>> interceptors) {
        return ImmutableList.copyOf(Iterables.transform(interceptors, this.reader.getInterceptorToInterceptorMetadataFunction()));
    }
}

