/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import jakarta.enterprise.lang.model.AnnotationInfo;
import jakarta.enterprise.lang.model.AnnotationMember;
import jakarta.enterprise.lang.model.declarations.ClassInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jboss.weld.lite.extension.translator.AnnotationMemberImpl;
import org.jboss.weld.lite.extension.translator.BeanManagerAccess;
import org.jboss.weld.lite.extension.translator.ClassInfoImpl;

class AnnotationInfoImpl
implements AnnotationInfo {
    final Annotation annotation;

    AnnotationInfoImpl(Annotation annotation) {
        this.annotation = annotation;
    }

    public ClassInfo declaration() {
        return new ClassInfoImpl(BeanManagerAccess.createAnnotatedType(this.annotation.annotationType()));
    }

    public boolean hasMember(String name) {
        try {
            this.annotation.annotationType().getDeclaredMethod(name, new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public AnnotationMember member(String name) {
        try {
            Method member = this.annotation.annotationType().getDeclaredMethod(name, new Class[0]);
            member.setAccessible(true);
            Object value = member.invoke((Object)this.annotation, new Object[0]);
            return new AnnotationMemberImpl(value);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, AnnotationMember> members() {
        try {
            Method[] members = this.annotation.annotationType().getDeclaredMethods();
            HashMap<String, AnnotationMember> result = new HashMap<String, AnnotationMember>();
            for (Method member : members) {
                member.setAccessible(true);
                String name = member.getName();
                Object value = member.invoke((Object)this.annotation, new Object[0]);
                result.put(name, new AnnotationMemberImpl(value));
            }
            return result;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotationInfoImpl that = (AnnotationInfoImpl)o;
        return Objects.equals(this.annotation, that.annotation);
    }

    public int hashCode() {
        return Objects.hash(this.annotation);
    }

    public String toString() {
        return this.annotation.toString();
    }
}

