/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import jakarta.enterprise.inject.spi.AnnotatedCallable;
import jakarta.enterprise.inject.spi.AnnotatedConstructor;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.lang.model.declarations.ClassInfo;
import jakarta.enterprise.lang.model.declarations.FieldInfo;
import jakarta.enterprise.lang.model.declarations.MethodInfo;
import jakarta.enterprise.lang.model.declarations.PackageInfo;
import jakarta.enterprise.lang.model.declarations.RecordComponentInfo;
import jakarta.enterprise.lang.model.types.Type;
import jakarta.enterprise.lang.model.types.TypeVariable;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedTypeVariable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jboss.weld.lite.extension.translator.DeclarationInfoImpl;
import org.jboss.weld.lite.extension.translator.FieldInfoImpl;
import org.jboss.weld.lite.extension.translator.MethodInfoImpl;
import org.jboss.weld.lite.extension.translator.PackageInfoImpl;
import org.jboss.weld.lite.extension.translator.ReflectionMembers;
import org.jboss.weld.lite.extension.translator.SecurityActions;
import org.jboss.weld.lite.extension.translator.TypeImpl;
import org.jboss.weld.lite.extension.translator.TypeVariableImpl;
import org.jboss.weld.lite.extension.translator.util.reflection.AnnotatedTypes;

class ClassInfoImpl
extends DeclarationInfoImpl<Class<?>, jakarta.enterprise.inject.spi.AnnotatedType<?>>
implements ClassInfo {
    private final String name;

    ClassInfoImpl(jakarta.enterprise.inject.spi.AnnotatedType<?> cdiDeclaration, BeanManager bm) {
        super(cdiDeclaration.getJavaClass(), cdiDeclaration, bm);
        this.name = cdiDeclaration.getJavaClass().getName();
    }

    public String name() {
        return ((Class)this.reflection).getName();
    }

    public String simpleName() {
        return ((Class)this.reflection).getSimpleName();
    }

    public PackageInfo packageInfo() {
        return new PackageInfoImpl(((Class)this.reflection).getPackage(), this.bm);
    }

    public List<TypeVariable> typeParameters() {
        return Arrays.stream(((Class)this.reflection).getTypeParameters()).map(AnnotatedTypes::typeVariable).map(annotatedTypeVariable -> new TypeVariableImpl((AnnotatedTypeVariable)annotatedTypeVariable, this.bm)).collect(Collectors.toList());
    }

    public Type superClass() {
        AnnotatedType superClass = ((Class)this.reflection).getAnnotatedSuperclass();
        return superClass != null ? TypeImpl.fromReflectionType(superClass, this.bm) : null;
    }

    public ClassInfo superClassDeclaration() {
        Class superClass = ((Class)this.reflection).getSuperclass();
        return superClass != null ? new ClassInfoImpl(this.bm.createAnnotatedType(superClass), this.bm) : null;
    }

    public List<Type> superInterfaces() {
        AnnotatedType[] interfaces = ((Class)this.reflection).getAnnotatedInterfaces();
        return Arrays.stream(interfaces).map(annotatedType -> TypeImpl.fromReflectionType(annotatedType, this.bm)).collect(Collectors.toList());
    }

    public List<ClassInfo> superInterfacesDeclarations() {
        return Arrays.stream(((Class)this.reflection).getInterfaces()).map(it -> new ClassInfoImpl(this.bm.createAnnotatedType(it), this.bm)).collect(Collectors.toList());
    }

    public boolean isPlainClass() {
        return !this.isInterface() && !this.isEnum() && !this.isAnnotation() && !this.isRecord();
    }

    public boolean isInterface() {
        if (this.isAnnotation()) {
            return false;
        }
        return ((Class)this.reflection).isInterface();
    }

    public boolean isEnum() {
        return ((Class)this.reflection).isEnum();
    }

    public boolean isAnnotation() {
        return ((Class)this.reflection).isAnnotation();
    }

    public boolean isRecord() {
        Class superclass = ((Class)this.reflection).getSuperclass();
        return superclass != null && superclass.getName().equals("java.lang.Record");
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(((Class)this.reflection).getModifiers());
    }

    public boolean isFinal() {
        return Modifier.isFinal(((Class)this.reflection).getModifiers());
    }

    public int modifiers() {
        return ((Class)this.reflection).getModifiers();
    }

    public Collection<MethodInfo> constructors() {
        HashMap<Constructor, AnnotatedConstructor> map = new HashMap<Constructor, AnnotatedConstructor>();
        for (AnnotatedConstructor constructor : ((jakarta.enterprise.inject.spi.AnnotatedType)this.cdiDeclaration).getConstructors()) {
            map.put(constructor.getJavaMember(), constructor);
        }
        return Arrays.stream(SecurityActions.getDeclaredConstructors((Class)this.reflection)).filter(it -> !it.isSynthetic()).map(it -> {
            if (map.containsKey(it)) {
                return new MethodInfoImpl((AnnotatedCallable)map.get(it), this.bm);
            }
            return new MethodInfoImpl((Executable)it, this.bm);
        }).collect(Collectors.toList());
    }

    public Collection<MethodInfo> methods() {
        HashMap<Method, AnnotatedMethod> map = new HashMap<Method, AnnotatedMethod>();
        for (AnnotatedMethod method : ((jakarta.enterprise.inject.spi.AnnotatedType)this.cdiDeclaration).getMethods()) {
            map.put(method.getJavaMember(), method);
        }
        return ReflectionMembers.allMethods((Class)this.reflection).stream().filter(it -> !it.isSynthetic()).map(it -> {
            if (map.containsKey(it)) {
                return new MethodInfoImpl((AnnotatedCallable)map.get(it), this.bm);
            }
            return new MethodInfoImpl((Executable)it, this.bm);
        }).collect(Collectors.toList());
    }

    public Collection<FieldInfo> fields() {
        HashMap<Field, AnnotatedField> map = new HashMap<Field, AnnotatedField>();
        for (AnnotatedField field : ((jakarta.enterprise.inject.spi.AnnotatedType)this.cdiDeclaration).getFields()) {
            map.put(field.getJavaMember(), field);
        }
        return ReflectionMembers.allFields((Class)this.reflection).stream().filter(it -> !it.isSynthetic()).map(it -> {
            if (map.containsKey(it)) {
                return new FieldInfoImpl((AnnotatedField)map.get(it), this.bm);
            }
            return new FieldInfoImpl((Field)it, this.bm);
        }).collect(Collectors.toList());
    }

    public Collection<RecordComponentInfo> recordComponents() {
        if (this.isRecord()) {
            throw new UnsupportedOperationException("Records not yet supported");
        }
        return Collections.emptyList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassInfoImpl classInfo = (ClassInfoImpl)o;
        return Objects.equals(this.name, classInfo.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

