/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.attributes;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.weld.bean.attributes.ImmutableBeanAttributes;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.logging.messages.MetadataMessage;

public class ExternalBeanAttributesFactory {
    public static <T> BeanAttributes<T> of(BeanAttributes<T> source, BeanManager manager) {
        ExternalBeanAttributesFactory.validateBeanAttributes(source, manager);
        ImmutableBeanAttributes attributes = new ImmutableBeanAttributes(ExternalBeanAttributesFactory.defensiveCopy(source.getStereotypes()), source.isAlternative(), source.getName(), ExternalBeanAttributesFactory.defensiveCopy(source.getQualifiers()), ExternalBeanAttributesFactory.defensiveCopy(source.getTypes()), source.getScope());
        return attributes;
    }

    private static <T> Set<T> defensiveCopy(Set<T> set) {
        return new HashSet<T>(set);
    }

    public static void validateBeanAttributes(BeanAttributes<?> attributes, BeanManager manager) {
        ExternalBeanAttributesFactory.validateStereotypes(attributes, manager);
        ExternalBeanAttributesFactory.validateQualifiers(attributes, manager);
        ExternalBeanAttributesFactory.validateTypes(attributes, manager);
        ExternalBeanAttributesFactory.validateScope(attributes, manager);
    }

    public static void validateStereotypes(BeanAttributes<?> attributes, BeanManager manager) {
        ExternalBeanAttributesFactory.checkNull(attributes.getStereotypes(), MetadataMessage.STEREOTYPES_NULL, attributes);
        for (Class<Annotation> annotation : attributes.getStereotypes()) {
            if (manager.isStereotype(annotation)) continue;
            throw new DefinitionException(MetadataMessage.NOT_A_STEREOTYPE, annotation, attributes);
        }
    }

    public static void validateQualifiers(BeanAttributes<?> attributes, BeanManager manager) {
        ExternalBeanAttributesFactory.checkNull(attributes.getQualifiers(), MetadataMessage.QUALIFIERS_NULL, attributes);
        for (Annotation annotation : attributes.getQualifiers()) {
            if (manager.isQualifier(annotation.annotationType())) continue;
            throw new DefinitionException(MetadataMessage.NOT_A_QUALIFIER, annotation.annotationType(), attributes);
        }
    }

    public static void validateTypes(BeanAttributes<?> attributes, BeanManager manager) {
        ExternalBeanAttributesFactory.checkNull(attributes.getTypes(), MetadataMessage.TYPES_NULL, attributes);
        if (attributes.getTypes().isEmpty()) {
            throw new DefinitionException(MetadataMessage.TYPES_EMPTY, attributes);
        }
    }

    public static void validateScope(BeanAttributes<?> attributes, BeanManager manager) {
        ExternalBeanAttributesFactory.checkNull(attributes.getScope(), MetadataMessage.SCOPE_NULL, attributes);
        if (!manager.isScope(attributes.getScope())) {
            throw new DefinitionException(MetadataMessage.NOT_A_SCOPE, attributes.getScope(), attributes);
        }
    }

    public static <E extends Enum<?>> void checkNull(Object object, E key, Object ... objects) {
        if (object == null) {
            throw new DefinitionException(key, objects);
        }
    }
}

