/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resources;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MapMaker;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.NormalScope;
import javax.inject.Scope;
import org.jboss.weld.bootstrap.api.helpers.AbstractBootstrapService;
import org.jboss.weld.metadata.TypeStore;
import org.jboss.weld.resources.ReflectionCache;
import org.jboss.weld.util.collections.Arrays2;

public class DefaultReflectionCache
extends AbstractBootstrapService
implements ReflectionCache {
    private final TypeStore store;
    private final Map<AnnotatedElement, Annotations> annotations;
    private final Map<AnnotatedElement, Annotations> declaredAnnotations;
    private final Map<Constructor<?>, Annotation[][]> constructorParameterAnnotations;
    private final Map<Method, Annotation[][]> methodParameterAnnotations;
    private final Map<Class<?>, Set<Annotation>> backedAnnotatedTypeAnnotations;
    private final Map<Class<? extends Annotation>, Boolean> isScopeAnnotation;

    protected Annotation[] internalGetAnnotations(AnnotatedElement element) {
        return element.getAnnotations();
    }

    protected Annotation[] internalGetDeclaredAnnotations(AnnotatedElement element) {
        return element.getDeclaredAnnotations();
    }

    public DefaultReflectionCache(TypeStore store) {
        this.store = store;
        MapMaker maker = new MapMaker();
        this.annotations = maker.makeComputingMap(new Function<AnnotatedElement, Annotations>(){

            @Override
            public Annotations apply(AnnotatedElement input) {
                return new Annotations(DefaultReflectionCache.this.internalGetAnnotations(input));
            }
        });
        this.declaredAnnotations = maker.makeComputingMap(new Function<AnnotatedElement, Annotations>(){

            @Override
            public Annotations apply(AnnotatedElement input) {
                return new Annotations(DefaultReflectionCache.this.internalGetDeclaredAnnotations(input));
            }
        });
        this.constructorParameterAnnotations = maker.makeComputingMap(new Function<Constructor<?>, Annotation[][]>(){

            @Override
            public Annotation[][] apply(Constructor<?> input) {
                return input.getParameterAnnotations();
            }
        });
        this.methodParameterAnnotations = maker.makeComputingMap(new Function<Method, Annotation[][]>(){

            @Override
            public Annotation[][] apply(Method input) {
                return input.getParameterAnnotations();
            }
        });
        this.backedAnnotatedTypeAnnotations = maker.makeComputingMap(new BackedAnnotatedTypeAnnotationsFunction());
        this.isScopeAnnotation = maker.makeComputingMap(new IsScopeAnnotationFunction());
    }

    @Override
    public Annotation[] getAnnotations(AnnotatedElement element) {
        return this.annotations.get(element).annotations;
    }

    @Override
    public Annotation[] getDeclaredAnnotations(AnnotatedElement element) {
        return this.declaredAnnotations.get(element).annotations;
    }

    @Override
    public Annotation[] getParameterAnnotations(Constructor<?> constructor, int parameterPosition) {
        return this.constructorParameterAnnotations.get(constructor)[parameterPosition];
    }

    @Override
    public Annotation[] getParameterAnnotations(Method method, int parameterPosition) {
        return this.methodParameterAnnotations.get(method)[parameterPosition];
    }

    @Override
    public void cleanupAfterBoot() {
        this.annotations.clear();
        this.declaredAnnotations.clear();
        this.constructorParameterAnnotations.clear();
        this.methodParameterAnnotations.clear();
        this.backedAnnotatedTypeAnnotations.clear();
        this.isScopeAnnotation.clear();
    }

    @Override
    public Set<Annotation> getAnnotationSet(AnnotatedElement element) {
        return this.annotations.get(element).annotationSet;
    }

    @Override
    public Set<Annotation> getDeclaredAnnotationSet(AnnotatedElement element) {
        return this.declaredAnnotations.get(element).annotationSet;
    }

    @Override
    public Set<Annotation> getParameterAnnotationSet(Constructor<?> constructor, int parameterPosition) {
        return ImmutableSet.copyOf(this.getParameterAnnotations(constructor, parameterPosition));
    }

    @Override
    public Set<Annotation> getParameterAnnotationSet(Method method, int parameterPosition) {
        return ImmutableSet.copyOf(this.getParameterAnnotations(method, parameterPosition));
    }

    @Override
    public Set<Annotation> getBackedAnnotatedTypeAnnotationSet(Class<?> javaClass) {
        return this.backedAnnotatedTypeAnnotations.get(javaClass);
    }

    private class IsScopeAnnotationFunction
    implements Function<Class<? extends Annotation>, Boolean> {
        private IsScopeAnnotationFunction() {
        }

        @Override
        public Boolean apply(Class<? extends Annotation> input) {
            if (input.isAnnotationPresent(NormalScope.class)) {
                return true;
            }
            if (input.isAnnotationPresent(Scope.class)) {
                return true;
            }
            return DefaultReflectionCache.this.store.isExtraScope(input);
        }
    }

    private class BackedAnnotatedTypeAnnotationsFunction
    implements Function<Class<?>, Set<Annotation>> {
        private BackedAnnotatedTypeAnnotationsFunction() {
        }

        @Override
        public Set<Annotation> apply(Class<?> javaClass) {
            Set<Annotation> annotations = DefaultReflectionCache.this.getAnnotationSet(javaClass);
            boolean scopeFound = false;
            for (Annotation annotation : annotations) {
                boolean isScope = (Boolean)DefaultReflectionCache.this.isScopeAnnotation.get(annotation.annotationType());
                if (isScope && scopeFound) {
                    return this.applyScopeInheritanceRules(annotations, javaClass);
                }
                if (!isScope) continue;
                scopeFound = true;
            }
            return annotations;
        }

        public Set<Annotation> applyScopeInheritanceRules(Set<Annotation> annotations, Class<?> javaClass) {
            HashSet<Annotation> result = new HashSet<Annotation>();
            for (Annotation annotation : annotations) {
                if (((Boolean)DefaultReflectionCache.this.isScopeAnnotation.get(annotation.annotationType())).booleanValue()) continue;
                result.add(annotation);
            }
            result.addAll(this.findTopLevelScopeDefinitions(javaClass));
            return ImmutableSet.copyOf(result);
        }

        public Set<Annotation> findTopLevelScopeDefinitions(Class<?> javaClass) {
            for (Class<?> clazz = javaClass; clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
                HashSet<Annotation> scopes = new HashSet<Annotation>();
                for (Annotation annotation : DefaultReflectionCache.this.getDeclaredAnnotations(clazz)) {
                    if (!((Boolean)DefaultReflectionCache.this.isScopeAnnotation.get(annotation.annotationType())).booleanValue()) continue;
                    scopes.add(annotation);
                }
                if (scopes.size() <= 0) continue;
                return scopes;
            }
            throw new IllegalStateException();
        }
    }

    private static class Annotations {
        private final Annotation[] annotations;
        private final Set<Annotation> annotationSet;

        public Annotations(Annotation[] annotations) {
            if (annotations.length == 0) {
                this.annotations = Arrays2.EMPTY_ANNOTATION_ARRAY;
                this.annotationSet = Collections.emptySet();
            } else {
                this.annotations = annotations;
                this.annotationSet = ImmutableSet.copyOf(annotations);
            }
        }
    }
}

