/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.api.helpers;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.weld.bootstrap.api.Singleton;
import org.jboss.weld.bootstrap.api.SingletonProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistrySingletonProvider
extends SingletonProvider {
    public static final String STATIC_INSTANCE = "STATIC_INSTANCE";

    @Override
    public <T> Singleton<T> create(Class<? extends T> type) {
        return new RegistrySingleton();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RegistrySingleton<T>
    implements Singleton<T> {
        private final Map<String, T> store = new ConcurrentHashMap<String, T>();

        private RegistrySingleton() {
        }

        @Override
        public T get(String id) {
            T instance = this.store.get(id);
            if (instance == null) {
                throw new IllegalStateException("Singleton not set for " + id + " => " + this.store.keySet());
            }
            return instance;
        }

        @Override
        public void set(String id, T object) {
            this.store.put(id, object);
        }

        @Override
        public void clear(String id) {
            this.store.remove(id);
        }

        @Override
        public boolean isSet(String id) {
            return this.store.containsKey(id);
        }
    }
}

