/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.client.configuration;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.ws.common.utils.DelegateClassLoader;

class SecurityActions {
    SecurityActions() {
    }

    static ClassLoader getContextClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static void setContextClassLoader(final ClassLoader classLoader) {
        if (System.getSecurityManager() == null) {
            Thread.currentThread().setContextClassLoader(classLoader);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    return null;
                }
            });
        }
    }

    static Boolean getBoolean(final String propName, final Boolean defaultValue) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            String s = System.getProperty(propName);
            return s != null ? Boolean.valueOf(s) : defaultValue;
        }
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                String s = SecurityActions.getSystemProperty(propName, null);
                return s != null ? Boolean.valueOf(s) : defaultValue;
            }
        });
    }

    static boolean getBoolean(final String propName) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return Boolean.getBoolean(propName);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.getBoolean(propName);
            }
        });
    }

    static Long getLong(final String propName, final Long defaultValue) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return Long.getLong(propName, defaultValue);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Long>(){

            @Override
            public Long run() {
                return Long.getLong(propName, defaultValue);
            }
        });
    }

    static Integer getInteger(final String propName, final Integer defaultValue) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return Integer.getInteger(propName, defaultValue);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                return Integer.getInteger(propName, defaultValue);
            }
        });
    }

    static Integer getInteger(final String propName) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return Integer.getInteger(propName);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                return Integer.getInteger(propName);
            }
        });
    }

    static Class<?> loadClass(final ClassLoader cl, final String name) throws PrivilegedActionException, ClassNotFoundException {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return cl.loadClass(name);
        }
        return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

            @Override
            public Class<?> run() throws PrivilegedActionException {
                try {
                    return cl.loadClass(name);
                }
                catch (Exception e) {
                    throw new PrivilegedActionException(e);
                }
            }
        });
    }

    static String getSystemProperty(final String name, final String defaultValue) {
        PrivilegedAction<String> action = new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(name, defaultValue);
            }
        };
        return AccessController.doPrivileged(action);
    }

    static DelegateClassLoader createDelegateClassLoader(final ClassLoader clientClassLoader, final ClassLoader origClassLoader) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return new DelegateClassLoader(clientClassLoader, origClassLoader);
        }
        return AccessController.doPrivileged(new PrivilegedAction<DelegateClassLoader>(){

            @Override
            public DelegateClassLoader run() {
                return new DelegateClassLoader(clientClassLoader, origClassLoader);
            }
        });
    }
}

