/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.deployment;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.wsf.spi.deployment.Extensible;

public abstract class AbstractExtensible
implements Extensible {
    private final Map<Class<?>, Object> attachments;
    private final Map<String, Object> properties;

    public AbstractExtensible() {
        this.attachments = new HashMap();
        this.properties = new HashMap<String, Object>();
    }

    public AbstractExtensible(int initialAttachmentsSize, int initialPropertiesSize) {
        this.attachments = new HashMap(initialAttachmentsSize);
        this.properties = new HashMap<String, Object>(initialPropertiesSize);
    }

    public Collection<Object> getAttachments() {
        return this.attachments.values();
    }

    @Override
    public <T> T getAttachment(Class<T> clazz) {
        return (T)this.attachments.get(clazz);
    }

    @Override
    public <T> T addAttachment(Class<T> clazz, Object obj) {
        return (T)this.attachments.put(clazz, obj);
    }

    @Override
    public <T> T removeAttachment(Class<T> key) {
        return (T)this.attachments.remove(key);
    }

    @Override
    public Set<String> getProperties() {
        return this.properties.keySet();
    }

    @Override
    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    @Override
    public void removeProperty(String key) {
        this.properties.remove(key);
    }

    @Override
    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        this.properties.putAll(props);
    }
}

