/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.soap;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SAAJFactoryLoader;
import javax.xml.soap.SAAJMetaFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public abstract class MessageFactory {
    public static MessageFactory newInstance() throws SOAPException {
        MessageFactory factory = null;
        try {
            String propertyName = "javax.xml.soap.MessageFactory";
            factory = (MessageFactory)SAAJFactoryLoader.loadFactory(propertyName, null);
        }
        catch (RuntimeException rte) {
            throw new SOAPException(rte);
        }
        if (factory == null) {
            SAAJMetaFactory saajFactory = SAAJMetaFactory.getInstance();
            factory = saajFactory.newMessageFactory("SOAP 1.1 Protocol");
        }
        if (factory == null) {
            throw new SOAPException("Failed to to determine the MessageFactory implementation class");
        }
        return factory;
    }

    public static MessageFactory newInstance(String protocol) throws SOAPException {
        SAAJMetaFactory saajFactory = SAAJMetaFactory.getInstance();
        MessageFactory factory = saajFactory.newMessageFactory(protocol);
        if (factory == null) {
            throw new SOAPException("Failed to to determine the MessageFactory implementation class");
        }
        return factory;
    }

    public abstract SOAPMessage createMessage() throws SOAPException;

    public abstract SOAPMessage createMessage(MimeHeaders var1, InputStream var2) throws IOException, SOAPException;
}

