/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.ssl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.net.ssl.SSLContext;
import org.xnio.BufferAllocator;
import org.xnio.ByteBufferSlicePool;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.ConnectionChannelThread;
import org.xnio.Connector;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pool;
import org.xnio.ReadChannelThread;
import org.xnio.WriteChannelThread;
import org.xnio.Xnio;
import org.xnio.channels.AcceptingChannel;
import org.xnio.channels.BoundChannel;
import org.xnio.channels.ConnectedSslStreamChannel;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.ssl.JsseAcceptingSslStreamChannel;
import org.xnio.ssl.JsseConnectedSslStreamChannel;
import org.xnio.ssl.JsseSslUtils;
import org.xnio.ssl.XnioSsl;

public final class JsseXnioSsl
extends XnioSsl {
    private static final InetSocketAddress ANY_INET_ADDRESS = new InetSocketAddress(0);
    private final Pool<ByteBuffer> socketBufferPool;
    private final Pool<ByteBuffer> applicationBufferPool;
    private final SSLContext sslContext;

    public JsseXnioSsl(Xnio xnio, OptionMap optionMap) throws NoSuchProviderException, NoSuchAlgorithmException, KeyManagementException {
        super(xnio, optionMap);
        this.sslContext = JsseSslUtils.createSSLContext(optionMap);
        this.sslContext.getClientSessionContext().setSessionCacheSize(optionMap.get(Options.SSL_CLIENT_SESSION_CACHE_SIZE, 0));
        this.sslContext.getClientSessionContext().setSessionTimeout(optionMap.get(Options.SSL_CLIENT_SESSION_TIMEOUT, 0));
        this.sslContext.getServerSessionContext().setSessionCacheSize(optionMap.get(Options.SSL_SERVER_SESSION_CACHE_SIZE, 0));
        this.sslContext.getServerSessionContext().setSessionTimeout(optionMap.get(Options.SSL_SERVER_SESSION_TIMEOUT, 0));
        int appBufSize = optionMap.get(Options.SSL_APPLICATION_BUFFER_SIZE, 17000);
        int pktBufSize = optionMap.get(Options.SSL_PACKET_BUFFER_SIZE, 17000);
        int appBufRegionSize = optionMap.get(Options.SSL_APPLICATION_BUFFER_REGION_SIZE, appBufSize * 16);
        int pktBufRegionSize = optionMap.get(Options.SSL_PACKET_BUFFER_REGION_SIZE, pktBufSize * 16);
        this.socketBufferPool = new ByteBufferSlicePool(optionMap.get(Options.USE_DIRECT_BUFFERS, false) ? BufferAllocator.DIRECT_BYTE_BUFFER_ALLOCATOR : BufferAllocator.BYTE_BUFFER_ALLOCATOR, pktBufSize, pktBufRegionSize);
        this.applicationBufferPool = new ByteBufferSlicePool(BufferAllocator.BYTE_BUFFER_ALLOCATOR, appBufSize, appBufRegionSize);
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    @Override
    public IoFuture<ConnectedSslStreamChannel> connectSsl(InetSocketAddress destination, ConnectionChannelThread thread, ReadChannelThread readThread, WriteChannelThread writeThread, ChannelListener<? super ConnectedSslStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        return this.connectSsl(new InetSocketAddress(0), destination, thread, readThread, writeThread, openListener, bindListener, optionMap);
    }

    @Override
    public IoFuture<ConnectedSslStreamChannel> connectSsl(InetSocketAddress destination, ConnectionChannelThread thread, ReadChannelThread readThread, WriteChannelThread writeThread, ChannelListener<? super ConnectedSslStreamChannel> openListener, OptionMap optionMap) {
        return this.connectSsl(new InetSocketAddress(0), destination, thread, readThread, writeThread, openListener, null, optionMap);
    }

    @Override
    public AcceptingChannel<ConnectedSslStreamChannel> createSslTcpServer(InetSocketAddress bindAddress, ConnectionChannelThread thread, ChannelListener<? super AcceptingChannel<ConnectedSslStreamChannel>> acceptListener, OptionMap optionMap) throws IOException {
        JsseAcceptingSslStreamChannel server = new JsseAcceptingSslStreamChannel(this.sslContext, this.xnio.createStreamServer(bindAddress, thread, null, optionMap), optionMap, this.socketBufferPool, this.applicationBufferPool, optionMap.get(Options.SSL_STARTTLS, false));
        if (acceptListener != null) {
            server.getAcceptSetter().set(acceptListener);
        }
        return server;
    }

    ConnectedSslStreamChannel createSslConnectedStreamChannel(SSLContext sslContext, ConnectedStreamChannel tcpChannel, OptionMap optionMap, boolean server) {
        return new JsseConnectedSslStreamChannel(tcpChannel, JsseSslUtils.createSSLEngine(sslContext, optionMap, tcpChannel.getPeerAddress(InetSocketAddress.class), server), true, this.socketBufferPool, this.applicationBufferPool, optionMap.get(Options.SSL_STARTTLS, false));
    }

    @Override
    public IoFuture<ConnectedSslStreamChannel> connectSsl(InetSocketAddress bindAddress, InetSocketAddress destination, ConnectionChannelThread thread, ReadChannelThread readThread, WriteChannelThread writeThread, final ChannelListener<? super ConnectedSslStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, final OptionMap optionMap) {
        final FutureResult futureResult = new FutureResult(IoUtils.directExecutor());
        this.xnio.connectStream(bindAddress, destination, thread, readThread, writeThread, (ChannelListener<? super ConnectedStreamChannel>)new ChannelListener<ConnectedStreamChannel>(){

            @Override
            public void handleEvent(ConnectedStreamChannel tcpChannel) {
                ConnectedSslStreamChannel channel = JsseXnioSsl.this.createSslConnectedStreamChannel(JsseXnioSsl.this.sslContext, tcpChannel, optionMap, false);
                futureResult.setResult(channel);
                ChannelListeners.invokeChannelListener(channel, openListener);
            }
        }, bindListener, optionMap).addNotifier(new IoFuture.HandlingNotifier<ConnectedStreamChannel, FutureResult<ConnectedSslStreamChannel>>(){

            @Override
            public void handleCancelled(FutureResult<ConnectedSslStreamChannel> result) {
                result.setCancelled();
            }

            @Override
            public void handleFailed(IOException exception, FutureResult<ConnectedSslStreamChannel> result) {
                result.setException(exception);
            }
        }, futureResult);
        return futureResult.getIoFuture();
    }

    @Override
    public Connector<ConnectedSslStreamChannel> createSslTcpConnector(final InetSocketAddress src, final ConnectionChannelThread thread, final ReadChannelThread readThread, final WriteChannelThread writeThread, final OptionMap optionMap) {
        return new Connector<ConnectedSslStreamChannel>(){

            @Override
            public IoFuture<ConnectedSslStreamChannel> connectTo(SocketAddress destination, ChannelListener<? super ConnectedSslStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener) {
                return JsseXnioSsl.this.connectSsl(src, (InetSocketAddress)destination, thread, readThread, writeThread, openListener, bindListener, optionMap);
            }
        };
    }

    @Override
    public Connector<ConnectedSslStreamChannel> createSslTcpConnector(ConnectionChannelThread thread, ReadChannelThread readThread, WriteChannelThread writeThread, OptionMap optionMap) {
        return this.createSslTcpConnector(ANY_INET_ADDRESS, thread, readThread, writeThread, optionMap);
    }
}

