/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.logging.Logger;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Version;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.nio.NioXnioWorker;

final class NioXnio
extends Xnio {
    private static final Logger log = Logger.getLogger((String)"org.xnio.nio");
    private final SelectorCreator selectorCreator;
    static final boolean NIO2;
    private final ThreadLocal<Selector> selectorThreadLocal = new ThreadLocal<Selector>(){

        @Override
        public void remove() {
            IoUtils.safeClose((Selector)((Selector)this.get()));
            super.remove();
        }
    };

    NioXnio() {
        super("nio");
        String providerClassName = SelectorProvider.provider().getClass().getCanonicalName();
        if ("sun.nio.ch.PollSelectorProvider".equals(providerClassName)) {
            log.warnf("The currently defined selector provider class (%s) is not supported for use with XNIO", (Object)providerClassName);
        }
        log.tracef("Starting up with selector provider %s", (Object)providerClassName);
        this.selectorCreator = AccessController.doPrivileged(new PrivilegedAction<SelectorCreator>(){

            @Override
            public SelectorCreator run() {
                try {
                    Class<Selector> selectorImplClass = Class.forName("sun.nio.ch.PollSelectorImpl").asSubclass(Selector.class);
                    final Constructor<Selector> constructor = selectorImplClass.getDeclaredConstructor(SelectorProvider.class);
                    constructor.setAccessible(true);
                    log.trace((Object)"Using polling selector type for temporary selectors.");
                    return new SelectorCreator(){

                        @Override
                        public Selector open() throws IOException {
                            try {
                                return (Selector)constructor.newInstance(SelectorProvider.provider());
                            }
                            catch (InstantiationException e) {
                                return Selector.open();
                            }
                            catch (IllegalAccessException e) {
                                return Selector.open();
                            }
                            catch (InvocationTargetException e) {
                                try {
                                    throw e.getTargetException();
                                }
                                catch (IOException e2) {
                                    throw e2;
                                }
                                catch (RuntimeException e2) {
                                    throw e2;
                                }
                                catch (Error e2) {
                                    throw e2;
                                }
                                catch (Throwable t) {
                                    throw new IllegalStateException("Unexpected invocation exception", t);
                                }
                            }
                        }
                    };
                }
                catch (Exception exception) {
                    log.trace((Object)"Using default selector type for temporary selectors.");
                    return new SelectorCreator(){

                        @Override
                        public Selector open() throws IOException {
                            return Selector.open();
                        }
                    };
                }
            }
        });
    }

    public XnioWorker createWorker(ThreadGroup threadGroup, OptionMap optionMap, Runnable terminationTask) throws IOException, IllegalArgumentException {
        NioXnioWorker worker = new NioXnioWorker(this, threadGroup, optionMap, terminationTask);
        worker.start();
        return worker;
    }

    Selector getSelector() throws IOException {
        ThreadLocal<Selector> threadLocal = this.selectorThreadLocal;
        Selector selector = threadLocal.get();
        if (selector == null) {
            selector = this.selectorCreator.open();
            threadLocal.set(selector);
        }
        return selector;
    }

    static {
        log.info((Object)("XNIO NIO Implementation Version " + Version.VERSION));
        boolean nio2 = false;
        try {
            Class.forName("java.nio.channels.MulticastChannel", false, null);
            log.trace((Object)"NIO.2 detected");
            nio2 = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        NIO2 = nio2;
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                String bugLevel = System.getProperty("sun.nio.ch.bugLevel");
                if (bugLevel == null) {
                    System.setProperty("sun.nio.ch.bugLevel", "");
                }
                return null;
            }
        });
    }

    private static interface SelectorCreator {
        public Selector open() throws IOException;
    }
}

