/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.api.model;

import java.util.List;
import java.util.stream.Collectors;

public enum CaseStatus {
    OPEN(1, "open"),
    CLOSED(2, "closed"),
    CANCELLED(3, "cancelled");

    private final int id;
    private final String name;

    private CaseStatus(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public static CaseStatus fromId(int id) {
        switch (id) {
            case 1: {
                return OPEN;
            }
            case 2: {
                return CLOSED;
            }
            case 3: {
                return CANCELLED;
            }
        }
        return null;
    }

    public static CaseStatus fromName(String name) {
        if ("open".equalsIgnoreCase(name)) {
            return OPEN;
        }
        if ("closed".equalsIgnoreCase(name)) {
            return CLOSED;
        }
        if ("cancelled".equalsIgnoreCase(name)) {
            return CANCELLED;
        }
        return CaseStatus.valueOf(name);
    }

    public static List<CaseStatus> fromIdList(List<Integer> idList) {
        return idList != null ? idList.stream().map(event -> CaseStatus.fromId(event)).collect(Collectors.toList()) : null;
    }

    public static List<CaseStatus> fromNameList(List<String> nameList) {
        return nameList != null ? nameList.stream().map(event -> CaseStatus.fromName(event)).collect(Collectors.toList()) : null;
    }
}

