/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.impl.factory;

import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.impl.NodeInstanceFactory;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.kie.api.definition.process.Node;
import org.kie.api.runtime.process.NodeInstance;

public class CreateNewNodeFactory
implements NodeInstanceFactory {
    public final Class<? extends NodeInstance> cls;

    public CreateNewNodeFactory(Class<? extends NodeInstance> cls) {
        this.cls = cls;
    }

    @Override
    public NodeInstance getNodeInstance(Node node, WorkflowProcessInstance processInstance, org.kie.api.runtime.process.NodeInstanceContainer nodeInstanceContainer) {
        try {
            NodeInstanceImpl nodeInstance = (NodeInstanceImpl)this.cls.newInstance();
            nodeInstance.setNodeId(node.getId());
            nodeInstance.setNodeInstanceContainer(nodeInstanceContainer);
            nodeInstance.setProcessInstance(processInstance);
            String uniqueId = (String)node.getMetaData().get("UniqueId");
            assert (uniqueId != null) : node.getClass().getSimpleName() + " [" + node.getName() + "] does not have a unique id.";
            if (uniqueId == null) {
                uniqueId = node.getId() + "";
            }
            nodeInstance.setMetaData("UniqueId", uniqueId);
            int level = ((NodeInstanceContainer)nodeInstanceContainer).getLevelForNode(uniqueId);
            nodeInstance.setLevel(level);
            return nodeInstance;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to instantiate node: '" + this.cls.getName() + "':" + e.getMessage());
        }
    }
}

