/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.commands;

import java.util.List;
import org.jbpm.services.task.commands.TaskCommand;
import org.jbpm.services.task.commands.TaskContext;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.command.Context;

public class GetTaskAssignedAsPotentialOwnerCommand
extends TaskCommand<List<TaskSummary>> {
    private String language;
    private List<Status> status;

    public GetTaskAssignedAsPotentialOwnerCommand() {
    }

    public GetTaskAssignedAsPotentialOwnerCommand(String userId, String language) {
        this.userId = userId;
        this.language = language;
    }

    public GetTaskAssignedAsPotentialOwnerCommand(String userId, String language, List<Status> status) {
        this.userId = userId;
        this.language = language;
        this.status = status;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public List<Status> getStatuses() {
        return this.status;
    }

    public void setStatuses(List<Status> status) {
        this.status = status;
    }

    public List<TaskSummary> execute(Context cntxt) {
        TaskContext context = (TaskContext)cntxt;
        if (context.getTaskService() != null) {
            if (this.status == null) {
                return context.getTaskService().getTasksAssignedAsPotentialOwner(this.userId, this.language);
            }
            return context.getTaskService().getTasksAssignedAsPotentialOwnerByStatus(this.userId, this.status, this.language);
        }
        if (this.status == null) {
            return context.getTaskQueryService().getTasksAssignedAsPotentialOwner(this.userId, this.language);
        }
        return context.getTaskQueryService().getTasksAssignedAsPotentialOwnerByStatus(this.userId, this.status, this.language);
    }
}

