/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.services.task.events.TaskEventSupport;
import org.jbpm.services.task.impl.TaskContentRegistry;
import org.jbpm.services.task.utils.ContentMarshallerHelper;
import org.kie.api.task.model.Content;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.ContentMarshallerContext;
import org.kie.internal.task.api.TaskContentService;
import org.kie.internal.task.api.TaskContext;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.TaskPersistenceContext;
import org.kie.internal.task.api.model.ContentData;
import org.kie.internal.task.api.model.InternalContent;
import org.kie.internal.task.api.model.InternalTaskData;

public class TaskContentServiceImpl
implements TaskContentService {
    private TaskPersistenceContext persistenceContext;
    private TaskEventSupport taskEventSupport;
    private TaskContext context;

    public TaskContentServiceImpl() {
    }

    public TaskContentServiceImpl(TaskContext context, TaskPersistenceContext persistenceContext, TaskEventSupport taskEventSupport) {
        this.context = context;
        this.persistenceContext = persistenceContext;
        this.taskEventSupport = taskEventSupport;
    }

    public void setPersistenceContext(TaskPersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    public void setTaskEventSupport(TaskEventSupport taskEventSupport) {
        this.taskEventSupport = taskEventSupport;
    }

    public long addOutputContent(long taskId, Map<String, Object> params) {
        Task task = this.persistenceContext.findTask(Long.valueOf(taskId));
        this.loadTaskVariables(task);
        long outputContentId = task.getTaskData().getOutputContentId();
        Content outputContent = this.persistenceContext.findContent(Long.valueOf(outputContentId));
        HashMap<String, Object> initialContent = new HashMap<String, Object>();
        long contentId = -1L;
        if (outputContent == null) {
            ContentMarshallerContext context = this.getMarshallerContext(task);
            ContentData outputContentData = ContentMarshallerHelper.marshal(task, params, context.getEnvironment());
            Content content = TaskModelProvider.getFactory().newContent();
            ((InternalContent)content).setContent(outputContentData.getContent());
            this.persistenceContext.persistContent(content);
            this.persistenceContext.setOutputToTask(content, outputContentData, task);
            contentId = content.getId();
        } else {
            ContentMarshallerContext context = this.getMarshallerContext(task);
            Object unmarshalledObject = ContentMarshallerHelper.unmarshall(outputContent.getContent(), context.getEnvironment(), context.getClassloader());
            if (unmarshalledObject != null && unmarshalledObject instanceof Map) {
                initialContent.putAll((Map)unmarshalledObject);
                ((Map)unmarshalledObject).putAll(params);
            }
            ContentData outputContentData = ContentMarshallerHelper.marshal(task, unmarshalledObject, context.getEnvironment());
            ((InternalContent)outputContent).setContent(outputContentData.getContent());
            this.persistenceContext.persistContent(outputContent);
            contentId = outputContentId;
        }
        this.taskEventSupport.fireBeforeTaskOutputVariablesChanged(task, this.context, initialContent);
        ((InternalTaskData)task.getTaskData()).setTaskOutputVariables(params);
        this.taskEventSupport.fireAfterTaskOutputVariablesChanged(task, this.context, params);
        this.persistenceContext.updateTask(task);
        return contentId;
    }

    public long setDocumentContent(long taskId, Content content) {
        Task task = this.persistenceContext.findTask(Long.valueOf(taskId));
        this.persistenceContext.persistContent(content);
        ((InternalTaskData)task.getTaskData()).setDocumentContentId(content.getId().longValue());
        return content.getId();
    }

    public void deleteDocumentContent(long taskId, long contentId) {
        Task task = this.persistenceContext.findTask(Long.valueOf(taskId));
        ((InternalTaskData)task.getTaskData()).setDocumentContentId(-1L);
        Content content = this.persistenceContext.findContent(Long.valueOf(contentId));
        this.persistenceContext.removeContent(content);
    }

    public List<Content> getAllContentByTaskId(long taskId) {
        Task task = this.persistenceContext.findTask(Long.valueOf(taskId));
        long inputContentId = task.getTaskData().getDocumentContentId();
        long outputContentId = task.getTaskData().getOutputContentId();
        long faultContentId = task.getTaskData().getFaultContentId();
        ArrayList<Content> allContent = new ArrayList<Content>();
        allContent.add(this.persistenceContext.findContent(Long.valueOf(inputContentId)));
        allContent.add(this.persistenceContext.findContent(Long.valueOf(outputContentId)));
        allContent.add(this.persistenceContext.findContent(Long.valueOf(faultContentId)));
        return allContent;
    }

    public Content getContentById(long contentId) {
        return this.persistenceContext.findContent(Long.valueOf(contentId));
    }

    public void addMarshallerContext(String ownerId, ContentMarshallerContext context) {
        TaskContentRegistry.get().addMarshallerContext(ownerId, context);
    }

    public void removeMarshallerContext(String ownerId) {
        TaskContentRegistry.get().removeMarshallerContext(ownerId);
    }

    public ContentMarshallerContext getMarshallerContext(Task task) {
        return TaskContentRegistry.get().getMarshallerContext(task);
    }

    public Task loadTaskVariables(Task task) {
        if (task.getTaskData().getTaskInputVariables() == null) {
            Map<String, Object> input = this.loadContentData(task.getTaskData().getDocumentContentId(), task);
            ((InternalTaskData)task.getTaskData()).setTaskInputVariables(input);
        }
        if (task.getTaskData().getTaskOutputVariables() == null) {
            Map<String, Object> output = this.loadContentData(task.getTaskData().getOutputContentId(), task);
            ((InternalTaskData)task.getTaskData()).setTaskOutputVariables(output);
        }
        return task;
    }

    protected Map<String, Object> loadContentData(Long contentId, Task task) {
        if (contentId != null) {
            HashMap<String, Object> data = null;
            Content contentById = this.getContentById(contentId);
            if (contentById != null) {
                ContentMarshallerContext mContext = this.getMarshallerContext(task);
                Object unmarshalledObject = ContentMarshallerHelper.unmarshall(contentById.getContent(), mContext.getEnvironment(), mContext.getClassloader());
                if (!(unmarshalledObject instanceof Map)) {
                    data = new HashMap<String, Object>();
                    data.put("Content", unmarshalledObject);
                } else {
                    data = (HashMap<String, Object>)unmarshalledObject;
                }
                return data;
            }
        }
        return null;
    }
}

