/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.rule.impl;

import java.util.Map;
import org.jbpm.services.task.impl.TaskContentRegistry;
import org.jbpm.services.task.rule.RuleContextProvider;
import org.jbpm.services.task.rule.TaskRuleService;
import org.jbpm.services.task.rule.TaskServiceRequest;
import org.jbpm.services.task.utils.ContentMarshallerHelper;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.ContentMarshallerContext;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.model.ContentData;
import org.kie.internal.task.api.model.InternalOrganizationalEntity;
import org.kie.internal.task.exception.TaskException;

public class TaskRuleServiceImpl
implements TaskRuleService {
    private RuleContextProvider ruleContextProvider;

    public TaskRuleServiceImpl() {
    }

    public TaskRuleServiceImpl(RuleContextProvider ruleContextProvider) {
        this.ruleContextProvider = ruleContextProvider;
    }

    @Override
    public void executeRules(Task task, String userId, Object params, String scope) throws TaskException {
        KieBase ruleBase = this.ruleContextProvider.getKieBase(scope);
        if (ruleBase != null) {
            KieSession session = ruleBase.newKieSession();
            Map<String, Object> globals = this.ruleContextProvider.getGlobals(scope);
            if (globals != null) {
                for (Map.Entry<String, Object> entry : globals.entrySet()) {
                    session.setGlobal(entry.getKey(), entry.getValue());
                }
            }
            User user = TaskModelProvider.getFactory().newUser();
            ((InternalOrganizationalEntity)user).setId(userId);
            TaskServiceRequest request = new TaskServiceRequest(scope, user, null);
            session.setGlobal("request", (Object)request);
            session.insert((Object)task);
            if (params != null) {
                if (params instanceof ContentData) {
                    ContentMarshallerContext ctx = TaskContentRegistry.get().getMarshallerContext(task);
                    params = ContentMarshallerHelper.unmarshall(((ContentData)params).getContent(), ctx.getEnvironment(), ctx.getClassloader());
                }
                session.insert(params);
            }
            session.fireAllRules();
            session.dispose();
            if (!request.isAllowed()) {
                StringBuilder error = new StringBuilder("Cannot perform operation " + scope + " :\n");
                if (request.getReasons() != null) {
                    for (String reason : request.getReasons()) {
                        error.append(reason).append('\n');
                    }
                }
                throw request.getException(error.toString());
            }
        }
    }

    public RuleContextProvider getRuleContextProvider() {
        return this.ruleContextProvider;
    }

    public void setRuleContextProvider(RuleContextProvider ruleContextProvider) {
        this.ruleContextProvider = ruleContextProvider;
    }
}

