/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.kie.internal.identity.IdentityProvider;

public class DeploymentRolesManager {
    private static final int MAX_CACHE_ENTRIES = Integer.parseInt(System.getProperty("org.jbpm.service.cache.size", "100"));
    protected Map<String, List<String>> deploymentsRoles = new HashMap<String, List<String>>();
    protected Map<String, List<String>> userDeploymentIdsCache = new LinkedHashMap<String, List<String>>(){
        private static final long serialVersionUID = -2324394641773215253L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, List<String>> eldest) {
            return this.size() > MAX_CACHE_ENTRIES;
        }
    };

    public void addRolesForDeployment(String deploymentId, List<String> roles) {
        this.deploymentsRoles.put(deploymentId, roles);
        this.userDeploymentIdsCache.clear();
    }

    public void removeRolesForDeployment(String deploymentId) {
        this.deploymentsRoles.remove(deploymentId);
        this.userDeploymentIdsCache.clear();
    }

    public List<String> getDeploymentsForUser(IdentityProvider identityProvider) {
        String identityName = null;
        List roles = null;
        try {
            identityName = identityProvider.getName();
            roles = identityProvider.getRoles();
        }
        catch (Exception e) {
            return new ArrayList<String>();
        }
        List<String> usersDeploymentIds = this.userDeploymentIdsCache.get(identityName);
        if (usersDeploymentIds != null) {
            return usersDeploymentIds;
        }
        usersDeploymentIds = new ArrayList<String>();
        this.userDeploymentIdsCache.put(identityName, usersDeploymentIds);
        boolean isSecured = false;
        for (Map.Entry<String, List<String>> entry : this.deploymentsRoles.entrySet()) {
            if (entry.getValue().isEmpty() || CollectionUtils.containsAny((Collection)roles, (Collection)entry.getValue())) {
                usersDeploymentIds.add(entry.getKey());
            }
            if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
            isSecured = true;
        }
        if (isSecured && usersDeploymentIds.isEmpty()) {
            usersDeploymentIds.add("deployments-are-secured");
        }
        return usersDeploymentIds;
    }
}

