/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.api.query;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jbpm.services.api.query.QueryResultMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryMapperRegistry {
    public static final Logger logger = LoggerFactory.getLogger(QueryMapperRegistry.class);
    private static QueryMapperRegistry INSTANCE = new QueryMapperRegistry();
    private ConcurrentMap<String, QueryResultMapper<?>> knownMappers = new ConcurrentHashMap();

    protected QueryMapperRegistry() {
        this.discoverAndAddMappers(this.getClass().getClassLoader());
    }

    public static QueryMapperRegistry get() {
        return INSTANCE;
    }

    public QueryResultMapper<?> mapperFor(String name, Map<String, String> columnMapping) {
        if (!this.knownMappers.containsKey(name)) {
            throw new IllegalArgumentException("No mapper found with name " + name);
        }
        if (columnMapping == null) {
            return (QueryResultMapper)this.knownMappers.get(name);
        }
        return ((QueryResultMapper)this.knownMappers.get(name)).forColumnMapping(columnMapping);
    }

    public List<String> discoverAndAddMappers(ClassLoader cl) {
        ArrayList<String> added = new ArrayList<String>();
        ServiceLoader<QueryResultMapper> availableProviders = ServiceLoader.load(QueryResultMapper.class, cl);
        for (QueryResultMapper mapper : availableProviders) {
            QueryResultMapper existed = this.knownMappers.putIfAbsent(mapper.getName(), mapper);
            if (existed == null) {
                added.add(mapper.getName());
                logger.debug("Added mapper {} to the registry", (Object)mapper.getName());
                continue;
            }
            logger.debug("Mapper {} already existing in the registry", (Object)mapper.getName());
        }
        return added;
    }

    public void addMapper(QueryResultMapper<?> mapper) {
        QueryResultMapper<?> existed = this.knownMappers.putIfAbsent(mapper.getName(), mapper);
        if (existed == null) {
            logger.debug("Added mapper {} to the registry", (Object)mapper.getName());
        } else {
            logger.debug("Mapper {} already existing in the registry", (Object)mapper.getName());
        }
    }

    public void removeMapper(String mapperName) {
        QueryResultMapper existed = (QueryResultMapper)this.knownMappers.remove(mapperName);
        if (existed != null) {
            logger.debug("Removed mapper {} from the registry", (Object)mapperName);
        } else {
            logger.debug("Mapper {} not found in the registry", (Object)mapperName);
        }
    }
}

