/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.env;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Set;
import org.jbpm.pvm.env.Context;
import org.jbpm.pvm.env.Environment;
import org.jbpm.pvm.env.EnvironmentFactory;
import org.jbpm.pvm.internal.env.PvmEnvironment;
import org.jbpm.pvm.internal.env.PvmEnvironmentFactoryParser;
import org.jbpm.pvm.internal.log.Log;
import org.jbpm.pvm.internal.stream.FileStreamSource;
import org.jbpm.pvm.internal.stream.InputStreamSource;
import org.jbpm.pvm.internal.stream.ResourceStreamSource;
import org.jbpm.pvm.internal.stream.StreamSource;
import org.jbpm.pvm.internal.stream.StringStreamSource;
import org.jbpm.pvm.internal.stream.UrlStreamSource;
import org.jbpm.pvm.internal.wire.WireContext;
import org.jbpm.pvm.internal.wire.WireDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PvmEnvironmentFactory
extends EnvironmentFactory
implements Context {
    private static final long serialVersionUID = 1L;
    private static final Log log = Log.getLog(PvmEnvironmentFactory.class.getName());
    protected static PvmEnvironmentFactoryParser pvmEnvironmentFactoryParser = new PvmEnvironmentFactoryParser();
    protected WireContext environmentFactoryCtxWireContext = null;
    protected WireDefinition environmentCtxWireDefinition = null;

    public PvmEnvironmentFactory() {
    }

    public PvmEnvironmentFactory(String resource) {
        this(resource, null);
    }

    public PvmEnvironmentFactory(String resource, ClassLoader classLoader) {
        this(new ResourceStreamSource(resource, classLoader));
    }

    public PvmEnvironmentFactory(File file) {
        this(new FileStreamSource(file));
    }

    public PvmEnvironmentFactory(URL url) {
        this(new UrlStreamSource(url));
    }

    public PvmEnvironmentFactory(InputStream inputStream) {
        this(new InputStreamSource(inputStream));
    }

    public static PvmEnvironmentFactory parseXmlString(String xmlString) {
        return new PvmEnvironmentFactory(new StringStreamSource(xmlString));
    }

    PvmEnvironmentFactory(StreamSource streamSource) {
        PvmEnvironmentFactoryParser.getInstance().createParse().setDocumentObject(this).setStreamSource(streamSource).execute().checkProblems("pvm environment configuration " + streamSource);
    }

    @Override
    public Environment openEnvironment() {
        PvmEnvironment environment = new PvmEnvironment(this);
        log.debug("opening " + environment);
        ClassLoader classLoader = this.environmentFactoryCtxWireContext.getClassLoader();
        if (classLoader != null) {
            environment.setClassLoader(classLoader);
        }
        environment.addContext(this.environmentFactoryCtxWireContext);
        WireContext environmentContext = new WireContext(this.environmentCtxWireDefinition, "environment", environment, true);
        environment.addContext(environmentContext);
        try {
            environmentContext.create();
        }
        catch (RuntimeException e) {
            Environment.popEnvironment();
            throw e;
        }
        return environment;
    }

    @Override
    public void close() {
        this.environmentFactoryCtxWireContext.fire("close", null);
    }

    @Override
    public Object get(String key) {
        return this.environmentFactoryCtxWireContext.get(key);
    }

    @Override
    public <T> T get(Class<T> type) {
        return this.environmentFactoryCtxWireContext.get(type);
    }

    @Override
    public String getName() {
        return this.environmentFactoryCtxWireContext.getName();
    }

    @Override
    public boolean has(String key) {
        return this.environmentFactoryCtxWireContext.has(key);
    }

    @Override
    public Set<String> keys() {
        return this.environmentFactoryCtxWireContext.keys();
    }

    @Override
    public Object set(String key, Object value) {
        return this.environmentFactoryCtxWireContext.set(key, value);
    }

    public void setEnvironmentCtxWireDefinition(WireDefinition blockWireDefinition) {
        this.environmentCtxWireDefinition = blockWireDefinition;
    }

    public WireContext getEnvironmentFactoryCtxWireContext() {
        return this.environmentFactoryCtxWireContext;
    }

    public void setEnvironmentFactoryCtxWireContext(WireContext applicationWireContext) {
        this.environmentFactoryCtxWireContext = applicationWireContext;
    }

    public WireDefinition getEnvironmentCtxWireDefinition() {
        return this.environmentCtxWireDefinition;
    }
}

