/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.spring;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jbpm.pvm.env.Context;
import org.jbpm.pvm.internal.util.ReflectUtil;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringEnvironmentContext
implements Context {
    ApplicationContext applicationContext;
    Map<String, Object> cache = new HashMap<String, Object>();

    public SpringEnvironmentContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public boolean has(String key) {
        return this.applicationContext.isPrototype(key);
    }

    @Override
    public Object get(String key) {
        if (this.cache.containsKey(key)) {
            return this.cache.get(key);
        }
        if (this.has(key)) {
            Object bean = this.applicationContext.getBean(key);
            return bean;
        }
        return null;
    }

    @Override
    public <T> T get(Class<T> type) {
        String name = ReflectUtil.getUnqualifiedClassName(type);
        name = name.substring(0, 1).toLowerCase() + name.substring(1);
        return (T)this.get(name);
    }

    @Override
    public Set<String> keys() {
        HashSet<String> keys = new HashSet<String>();
        for (String key : this.applicationContext.getBeanDefinitionNames()) {
            if (!this.has(key)) continue;
            keys.add(key);
        }
        return keys;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public Object set(String key, Object value) {
        return null;
    }
}

