/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.stream;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import org.jbpm.pvm.PvmException;
import org.jbpm.pvm.internal.stream.StreamSource;

public class FileStreamSource
extends StreamSource {
    protected File file;

    public FileStreamSource(File file) {
        if (file == null) {
            throw new PvmException("file is null");
        }
        try {
            this.name = file.toURL().toString();
        }
        catch (MalformedURLException e) {
            this.name = file.toString();
        }
        this.file = file;
    }

    public InputStream openStream() {
        FileInputStream stream = null;
        try {
            if (!this.file.exists()) {
                throw new PvmException("file " + this.file + " doesn't exist");
            }
            if (this.file.isDirectory()) {
                throw new PvmException("file " + this.file + " is a directory");
            }
            stream = new FileInputStream(this.file);
        }
        catch (Exception e) {
            throw new PvmException("couldn't access file " + this.file + ": " + e.getMessage(), e);
        }
        return stream;
    }
}

