/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.type.converter;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jbpm.pvm.PvmException;
import org.jbpm.pvm.internal.type.Converter;

public class DateToStringConverter
implements Converter {
    private static final long serialVersionUID = 1L;
    DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");

    public Object convert(Object o) {
        return this.dateFormat.format((Date)o);
    }

    public Object revert(Object o) {
        try {
            return this.dateFormat.parseObject((String)o);
        }
        catch (ParseException e) {
            throw new PvmException("invalid date format in date variable: " + o, e);
        }
    }

    public boolean supports(Object value) {
        return value != null && value instanceof Date;
    }

    public void setFormat(String format) {
        this.dateFormat = new SimpleDateFormat(format);
    }
}

