/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.wire.binding;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import org.jbpm.pvm.internal.cal.BusinessCalendar;
import org.jbpm.pvm.internal.cal.Day;
import org.jbpm.pvm.internal.cal.DayPart;
import org.jbpm.pvm.internal.cal.Holiday;
import org.jbpm.pvm.internal.util.StringUtil;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.wire.binding.WireDescriptorBinding;
import org.jbpm.pvm.internal.wire.descriptor.ProvidedObjectDescriptor;
import org.jbpm.pvm.internal.xml.Parse;
import org.jbpm.pvm.internal.xml.Parser;
import org.w3c.dom.Element;

public class BusinessCalendarBinding
extends WireDescriptorBinding {
    public BusinessCalendarBinding() {
        super("business-calendar");
    }

    public Object parse(Element element, Parse parse, Parser parser) {
        BusinessCalendar businessCalendar = new BusinessCalendar();
        TimeZone timeZone = null;
        timeZone = element.hasAttribute("timezone") ? TimeZone.getTimeZone(element.getAttribute("timezone")) : TimeZone.getDefault();
        businessCalendar.setTimeZone(timeZone);
        String hourFormatText = "HH:mm";
        if (element.hasAttribute("hour-format")) {
            hourFormatText = element.getAttribute("hour-format");
        }
        SimpleDateFormat hourFormat = new SimpleDateFormat(hourFormatText);
        Day[] days = new Day[8];
        days[1] = this.parseDay(element, "sunday", hourFormat, businessCalendar, parse);
        days[2] = this.parseDay(element, "monday", hourFormat, businessCalendar, parse);
        days[3] = this.parseDay(element, "tuesday", hourFormat, businessCalendar, parse);
        days[4] = this.parseDay(element, "wednesday", hourFormat, businessCalendar, parse);
        days[5] = this.parseDay(element, "thursday", hourFormat, businessCalendar, parse);
        days[6] = this.parseDay(element, "friday", hourFormat, businessCalendar, parse);
        days[7] = this.parseDay(element, "saturday", hourFormat, businessCalendar, parse);
        businessCalendar.setDays(days);
        String dayFormatText = "dd/MM/yyyy";
        if (element.hasAttribute("day-format")) {
            dayFormatText = element.getAttribute("day-format");
        }
        SimpleDateFormat dayFormat = new SimpleDateFormat(dayFormatText);
        Holiday[] holidays = null;
        List<Element> holidayElements = XmlUtil.elements(element, "holiday");
        if (holidayElements != null) {
            holidays = new Holiday[holidayElements.size()];
            for (int i = 0; i < holidayElements.size(); ++i) {
                holidays[i] = this.parseHoliday(holidayElements.get(i), dayFormat, businessCalendar, parse);
            }
        }
        businessCalendar.setHolidays(holidays);
        ProvidedObjectDescriptor descriptor = new ProvidedObjectDescriptor(businessCalendar, true);
        return descriptor;
    }

    private Day parseDay(Element daysElement, String dayText, DateFormat hourFormat, BusinessCalendar businessCalendar, Parse parse) {
        Day day = new Day();
        day.setBusinessCalendar(businessCalendar);
        Element dayElement = XmlUtil.element(daysElement, dayText);
        if (dayElement != null) {
            ArrayList<DayPart> dayParts = new ArrayList<DayPart>();
            if (dayElement.hasAttribute("hours")) {
                int dayPartIndex = 0;
                String hours = dayElement.getAttribute("hours");
                for (String part : StringUtil.tokenize(hours, "and")) {
                    try {
                        int separatorIndex = part.indexOf(45);
                        if (separatorIndex == -1) {
                            throw new IllegalArgumentException("no dash (-)");
                        }
                        String fromText = part.substring(0, separatorIndex).trim().toLowerCase();
                        String toText = part.substring(separatorIndex + 1).trim().toLowerCase();
                        Date from = hourFormat.parse(fromText);
                        Date to = hourFormat.parse(toText);
                        GregorianCalendar calendar = new GregorianCalendar();
                        calendar.setTime(from);
                        int fromHour = calendar.get(11);
                        int fromMinute = calendar.get(12);
                        calendar.setTime(to);
                        int toHour = calendar.get(11);
                        if (toHour == 0) {
                            toHour = 24;
                        }
                        int toMinute = calendar.get(12);
                        DayPart dayPart = new DayPart();
                        dayPart.setDay(day);
                        dayPart.setIndex(dayPartIndex);
                        dayPart.setFromHour(fromHour);
                        dayPart.setFromMinute(fromMinute);
                        dayPart.setToHour(toHour);
                        dayPart.setToMinute(toMinute);
                        dayParts.add(dayPart);
                    }
                    catch (Exception e) {
                        parse.addProblem(dayText + " has invalid hours part '" + part + "': " + e.getMessage());
                    }
                    ++dayPartIndex;
                }
            } else {
                parse.addProblem(dayText + " must have attribute 'hours'");
            }
            DayPart[] dayPartArray = new DayPart[dayParts.size()];
            dayPartArray = dayParts.toArray(dayPartArray);
            day.setDayParts(dayPartArray);
        }
        return day;
    }

    private Holiday parseHoliday(Element holidayElement, DateFormat dayFormat, BusinessCalendar businessCalendar, Parse parse) {
        Holiday holiday = new Holiday();
        try {
            if (holidayElement.hasAttribute("period")) {
                String holidayPeriodText = holidayElement.getAttribute("period");
                int dashIndex = holidayPeriodText.indexOf(45);
                String fromDateText = null;
                String toDateText = null;
                if (dashIndex != -1) {
                    fromDateText = holidayPeriodText.substring(0, dashIndex).trim().toLowerCase();
                    toDateText = holidayPeriodText.substring(dashIndex + 1).trim().toLowerCase();
                } else {
                    toDateText = fromDateText = holidayPeriodText.trim().toLowerCase();
                }
                Date fromDate = dayFormat.parse(fromDateText);
                holiday.setFromDay(fromDate);
                Date toDate = dayFormat.parse(toDateText);
                holiday.setToDay(toDate);
            } else {
                parse.addProblem("attribute 'period' in element business-calendar is required");
            }
            Calendar calendar = businessCalendar.createCalendar();
            calendar.setTime(holiday.getToDay());
            calendar.add(5, 1);
            Date toDay = calendar.getTime();
            holiday.setToDay(toDay);
        }
        catch (Exception e) {
            parse.addProblem("couldn't parse holiday: " + XmlUtil.toString(holidayElement));
        }
        return holiday;
    }
}

