/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.wire.binding;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.wire.Descriptor;
import org.jbpm.pvm.internal.wire.binding.AbstractCollectionBinding;
import org.jbpm.pvm.internal.wire.binding.WireDescriptorBinding;
import org.jbpm.pvm.internal.wire.descriptor.MapDescriptor;
import org.jbpm.pvm.internal.xml.Parse;
import org.jbpm.pvm.internal.xml.Parser;
import org.w3c.dom.Element;

public class MapBinding
extends WireDescriptorBinding {
    public MapBinding() {
        super("map");
    }

    public Object parse(Element element, Parse parse, Parser parser) {
        Boolean isSynchronized;
        MapDescriptor descriptor = new MapDescriptor();
        String className = XmlUtil.attribute(element, "class");
        if (AbstractCollectionBinding.verify(className, Map.class, parse, parser)) {
            descriptor.setClassName(className);
        }
        if ((isSynchronized = XmlUtil.attributeBoolean(element, "synchronized", false, parse)) != null) {
            descriptor.setSynchronized(isSynchronized);
        }
        ArrayList<Descriptor> keyDescriptors = new ArrayList<Descriptor>();
        ArrayList<Descriptor> valueDescriptors = new ArrayList<Descriptor>();
        List<Element> elements = XmlUtil.elements(element);
        if (elements != null) {
            for (Element entryElement : elements) {
                if ("entry".equals(XmlUtil.getTagLocalName(entryElement))) {
                    Element keyElement = XmlUtil.element(entryElement, "key");
                    Element keyDescriptorElement = keyElement != null ? XmlUtil.element(keyElement) : null;
                    Descriptor keyDescriptor = (Descriptor)parser.parseElement(keyDescriptorElement, parse, "descriptor");
                    Element valueElement = XmlUtil.element(entryElement, "value");
                    Element valueDescriptorElement = valueElement != null ? XmlUtil.element(valueElement) : null;
                    Descriptor valueDescriptor = (Descriptor)parser.parseElement(valueDescriptorElement, parse, "descriptor");
                    if (keyDescriptor != null && valueDescriptor != null) {
                        keyDescriptors.add(keyDescriptor);
                        valueDescriptors.add(valueDescriptor);
                        continue;
                    }
                    parse.addProblem("entry must have key and value element with a single descriptor as contents: " + XmlUtil.toString(entryElement));
                    continue;
                }
                parse.addProblem("map can only contain entry elements: " + XmlUtil.toString(entryElement));
            }
        }
        descriptor.setKeyDescriptors(keyDescriptors);
        descriptor.setValueDescriptors(valueDescriptors);
        return descriptor;
    }
}

