/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.test.base;

import java.util.ArrayList;
import java.util.Iterator;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Table;
import org.jbpm.pvm.env.EnvironmentFactory;

public class Db {
    private static final String CLEAN_SQL_KEY = "cleanSql";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clean(EnvironmentFactory environmentFactory) {
        SessionFactory sessionFactory = environmentFactory.get(SessionFactory.class);
        String[] cleanSql = (String[])environmentFactory.get(CLEAN_SQL_KEY);
        if (cleanSql == null) {
            Configuration configuration = environmentFactory.get(Configuration.class);
            SessionFactoryImplementor sessionFactoryImplementor = (SessionFactoryImplementor)sessionFactory;
            Dialect dialect = sessionFactoryImplementor.getDialect();
            ArrayList<String> dropForeignKeysSql = new ArrayList<String>();
            ArrayList<String> createForeignKeysSql = new ArrayList<String>();
            Iterator iter = configuration.getTableMappings();
            while (iter.hasNext()) {
                Table table = (Table)iter.next();
                if (!table.isPhysicalTable()) continue;
                String catalog = table.getCatalog();
                String schema = table.getSchema();
                Iterator subIter = table.getForeignKeyIterator();
                while (subIter.hasNext()) {
                    ForeignKey fk = (ForeignKey)subIter.next();
                    if (!fk.isPhysicalConstraint()) continue;
                    dropForeignKeysSql.add(fk.sqlDropString(dialect, catalog, schema));
                    if (dialect instanceof MySQLDialect) {
                        dropForeignKeysSql.add("alter table " + table.getName() + " drop key " + fk.getName());
                    }
                    createForeignKeysSql.add(fk.sqlCreateString(dialect, (Mapping)sessionFactoryImplementor, catalog, schema));
                }
            }
            ArrayList<String> deleteSql = new ArrayList<String>();
            iter = configuration.getTableMappings();
            while (iter.hasNext()) {
                Table table = (Table)iter.next();
                if (!table.isPhysicalTable()) continue;
                deleteSql.add("delete from " + table.getName());
            }
            ArrayList<String> cleanSqlList = new ArrayList<String>();
            cleanSqlList.addAll(dropForeignKeysSql);
            cleanSqlList.addAll(deleteSql);
            cleanSqlList.addAll(createForeignKeysSql);
            cleanSql = cleanSqlList.toArray(new String[cleanSqlList.size()]);
            environmentFactory.set(CLEAN_SQL_KEY, cleanSql);
        }
        Session session = sessionFactory.openSession();
        try {
            for (String query : cleanSql) {
                session.createSQLQuery(query).executeUpdate();
            }
        }
        finally {
            session.close();
        }
    }
}

