/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.internal;

import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import com.google.common.reflect.TypeToken;
import java.io.Closeable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.Context;
import org.jclouds.blobstore.AsyncBlobStore;
import org.jclouds.blobstore.BlobMap;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.InputStreamMap;
import org.jclouds.blobstore.attr.ConsistencyModel;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.internal.BaseView;
import org.jclouds.location.Provider;
import org.jclouds.rest.Utils;

@Singleton
public class BlobStoreContextImpl
extends BaseView
implements BlobStoreContext {
    private final BlobMap.Factory blobMapFactory;
    private final InputStreamMap.Factory inputStreamMapFactory;
    private final AsyncBlobStore ablobStore;
    private final BlobStore blobStore;
    private final ConsistencyModel consistencyModel;
    private final Utils utils;
    private final BlobRequestSigner blobRequestSigner;

    @Inject
    public BlobStoreContextImpl(@Provider Context backend, @Provider TypeToken<? extends Context> backendType, BlobMap.Factory blobMapFactory, Utils utils, ConsistencyModel consistencyModel, InputStreamMap.Factory inputStreamMapFactory, AsyncBlobStore ablobStore, BlobStore blobStore, BlobRequestSigner blobRequestSigner) {
        super(backend, backendType);
        this.consistencyModel = (ConsistencyModel)((Object)Preconditions.checkNotNull((Object)((Object)consistencyModel), (Object)"consistencyModel"));
        this.blobMapFactory = (BlobMap.Factory)Preconditions.checkNotNull((Object)blobMapFactory, (Object)"blobMapFactory");
        this.inputStreamMapFactory = (InputStreamMap.Factory)Preconditions.checkNotNull((Object)inputStreamMapFactory, (Object)"inputStreamMapFactory");
        this.ablobStore = (AsyncBlobStore)Preconditions.checkNotNull((Object)ablobStore, (Object)"ablobStore");
        this.blobStore = (BlobStore)Preconditions.checkNotNull((Object)blobStore, (Object)"blobStore");
        this.utils = (Utils)Preconditions.checkNotNull((Object)utils, (Object)"utils");
        this.blobRequestSigner = (BlobRequestSigner)Preconditions.checkNotNull((Object)blobRequestSigner, (Object)"blobRequestSigner");
    }

    @Override
    public ConsistencyModel getConsistencyModel() {
        return this.consistencyModel;
    }

    @Override
    public BlobMap createBlobMap(String container, ListContainerOptions options) {
        return this.blobMapFactory.create(container, options);
    }

    @Override
    public BlobMap createBlobMap(String container) {
        return this.blobMapFactory.create(container, ListContainerOptions.NONE);
    }

    @Override
    public InputStreamMap createInputStreamMap(String container, ListContainerOptions options) {
        return this.inputStreamMapFactory.create(container, options);
    }

    @Override
    public InputStreamMap createInputStreamMap(String container) {
        return this.inputStreamMapFactory.create(container, ListContainerOptions.NONE);
    }

    @Override
    public BlobStore getBlobStore() {
        return this.blobStore;
    }

    @Override
    public AsyncBlobStore getAsyncBlobStore() {
        return this.ablobStore;
    }

    @Override
    public Utils getUtils() {
        return this.utils();
    }

    @Override
    public Utils utils() {
        return this.utils;
    }

    @Override
    public BlobRequestSigner getSigner() {
        return this.blobRequestSigner;
    }

    @Override
    public void close() {
        Closeables.closeQuietly((Closeable)this.delegate());
    }

    public int hashCode() {
        return this.delegate().hashCode();
    }

    public String toString() {
        return this.delegate().toString();
    }

    public boolean equals(Object obj) {
        return this.delegate().equals(obj);
    }
}

