/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.options;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.jclouds.blobstore.options.ListOptions;

public class ListContainerOptions
extends ListOptions
implements Cloneable {
    public static final ImmutableListContainerOptions NONE = new ImmutableListContainerOptions(new ListContainerOptions());
    private String dir;
    private boolean recursive;
    private boolean detailed;

    public ListContainerOptions() {
    }

    ListContainerOptions(Integer maxKeys, String marker, String dir, boolean recursive, boolean detailed) {
        super(maxKeys, marker);
        this.dir = dir;
        this.recursive = recursive;
        this.detailed = detailed;
    }

    public String getDir() {
        return this.dir;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public boolean isDetailed() {
        return this.detailed;
    }

    public ListContainerOptions inDirectory(String dir) {
        Preconditions.checkNotNull((Object)dir, (Object)"dir");
        Preconditions.checkArgument((!dir.equals("/") ? 1 : 0) != 0, (Object)"dir must not be a slash");
        this.dir = dir;
        return this;
    }

    @Override
    public ListContainerOptions afterMarker(String marker) {
        return (ListContainerOptions)super.afterMarker(marker);
    }

    @Override
    public ListContainerOptions maxResults(int maxKeys) {
        return (ListContainerOptions)super.maxResults(maxKeys);
    }

    public ListContainerOptions recursive() {
        this.recursive = true;
        return this;
    }

    public ListContainerOptions withDetails() {
        this.detailed = true;
        return this;
    }

    @Override
    public ListContainerOptions clone() {
        return new ListContainerOptions(this.getMaxResults(), this.getMarker(), this.dir, this.recursive, this.detailed);
    }

    public String toString() {
        return "[dir=" + this.dir + ", recursive=" + this.recursive + ", detailed=" + this.detailed + ", maxResults=" + this.getMaxResults() + "]";
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.detailed, this.recursive, this.dir, this.getMarker(), this.getMaxResults()});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ListContainerOptions other = (ListContainerOptions)obj;
        return this.detailed == other.detailed && this.recursive == other.recursive && Objects.equal((Object)this.dir, (Object)other.dir) && Objects.equal((Object)this.getMarker(), (Object)other.getMarker()) && Objects.equal((Object)this.getMaxResults(), (Object)other.getMaxResults());
    }

    public static class Builder {
        public static ListContainerOptions inDirectory(String directory) {
            ListContainerOptions options = new ListContainerOptions();
            return options.inDirectory(directory);
        }

        public static ListContainerOptions afterMarker(String marker) {
            ListContainerOptions options = new ListContainerOptions();
            return options.afterMarker(marker);
        }

        public static ListContainerOptions maxResults(int maxKeys) {
            ListContainerOptions options = new ListContainerOptions();
            return options.maxResults(maxKeys);
        }

        public static ListContainerOptions recursive() {
            ListContainerOptions options = new ListContainerOptions();
            return options.recursive();
        }

        public static ListContainerOptions withDetails() {
            ListContainerOptions options = new ListContainerOptions();
            return options.withDetails();
        }
    }

    public static class ImmutableListContainerOptions
    extends ListContainerOptions {
        private final ListContainerOptions delegate;

        @Override
        public ListContainerOptions afterMarker(String marker) {
            throw new UnsupportedOperationException();
        }

        public ImmutableListContainerOptions(ListContainerOptions delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getDir() {
            return this.delegate.getDir();
        }

        @Override
        public ListContainerOptions inDirectory(String dir) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isDetailed() {
            return this.delegate.isDetailed();
        }

        @Override
        public boolean isRecursive() {
            return this.delegate.isRecursive();
        }

        @Override
        public ListContainerOptions maxResults(int maxKeys) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListContainerOptions recursive() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMarker() {
            return this.delegate.getMarker();
        }

        @Override
        public Integer getMaxResults() {
            return this.delegate.getMaxResults();
        }

        @Override
        public ListContainerOptions clone() {
            return this.delegate.clone();
        }

        @Override
        public String toString() {
            return this.delegate.toString();
        }
    }
}

