/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.config;

import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import com.google.inject.Binder;
import com.google.inject.TypeLiteral;
import java.lang.reflect.Type;
import org.jclouds.rest.config.AsyncHttpApiProvider;
import org.jclouds.rest.config.CallGetOnFuturesProvider;
import org.jclouds.rest.config.HttpApiProvider;

public class BinderUtils {
    public static <S, A> void bindHttpApi(Binder binder, Class<S> sync, Class<A> async) {
        BinderUtils.bindClass(binder, sync);
        BinderUtils.bindClass(binder, async);
        BinderUtils.bindAsyncHttpApiProvider(binder, async);
        BinderUtils.bindHttpApiProvider(binder, sync, async);
    }

    private static <T> void bindAsyncHttpApiProvider(Binder binder, Class<T> async) {
        TypeToken token = new TypeToken<AsyncHttpApiProvider<T>>(){
            private static final long serialVersionUID = 1L;
        }.where(new TypeParameter<T>(){}, async);
        binder.bind(async).toProvider((TypeLiteral)TypeLiteral.class.cast(TypeLiteral.get((Type)token.getType())));
    }

    private static <S, A> void bindHttpApiProvider(Binder binder, Class<S> sync, Class<A> async) {
        TypeToken token = new TypeToken<HttpApiProvider<S, A>>(){
            private static final long serialVersionUID = 1L;
        }.where(new TypeParameter<S>(){}, sync).where(new TypeParameter<A>(){}, async);
        binder.bind(sync).toProvider((TypeLiteral)TypeLiteral.class.cast(TypeLiteral.get((Type)token.getType())));
    }

    public static <S, A> void bindBlockingApi(Binder binder, Class<S> sync, Class<A> async) {
        BinderUtils.bindClass(binder, sync);
        BinderUtils.bindClass(binder, async);
        BinderUtils.bindCallGetOnFutures(binder, sync, async);
    }

    private static <S, A> void bindCallGetOnFutures(Binder binder, Class<S> sync, Class<A> async) {
        TypeToken token = new TypeToken<CallGetOnFuturesProvider<S, A>>(){
            private static final long serialVersionUID = 1L;
        }.where(new TypeParameter<S>(){}, sync).where(new TypeParameter<A>(){}, async);
        binder.bind(sync).toProvider((TypeLiteral)TypeLiteral.class.cast(TypeLiteral.get((Type)token.getType())));
    }

    private static <K> void bindClass(Binder binder, Class<K> sync) {
        binder.bind((TypeLiteral)TypeLiteral.class.cast(TypeLiteral.get((Type)new TypeToken<Class<K>>(){
            private static final long serialVersionUID = 1L;
        }.where(new TypeParameter<K>(){}, sync).getType()))).toInstance(sync);
    }
}

