/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.config;

import com.google.common.base.Function;
import com.google.common.cache.Cache;
import com.google.common.reflect.Invokable;
import com.google.inject.Provider;
import java.lang.reflect.Proxy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.reflect.Invocation;
import org.jclouds.rest.config.RestModule;
import org.jclouds.rest.internal.DelegatesToInvocationFunction;

@Singleton
public class HttpApiProvider<S, A>
implements Provider<S> {
    private final Class<? super S> apiType;
    private final DelegatesToInvocationFunction<S, Function<Invocation, Object>> httpInvoker;

    @Inject
    private HttpApiProvider(Cache<Invokable<?, ?>, Invokable<?, ?>> invokables, DelegatesToInvocationFunction<S, Function<Invocation, Object>> httpInvoker, Class<S> apiType, Class<A> asyncApiType) {
        this.httpInvoker = httpInvoker;
        this.apiType = apiType;
        RestModule.putInvokables(apiType, asyncApiType, invokables);
    }

    @Singleton
    public S get() {
        return (S)Proxy.newProxyInstance(this.apiType.getClassLoader(), new Class[]{this.apiType}, this.httpInvoker);
    }
}

